/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ApplicationType;
import com.okta.sdk.resource.model.EndpointAuthMethod;
import com.okta.sdk.resource.model.GrantType;
import com.okta.sdk.resource.model.ResponseType;
import com.okta.sdk.resource.model.SigningAlgorithm;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"application_type", "client_id", "client_id_issued_at", "client_name", "client_secret", "client_secret_expires_at", "frontchannel_logout_session_required", "frontchannel_logout_uri", "grant_types", "initiate_login_uri", "jwks_uri", "logo_uri", "policy_uri", "post_logout_redirect_uris", "redirect_uris", "request_object_signing_alg", "response_types", "token_endpoint_auth_method", "tos_uri"})
public class Client
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APPLICATION_TYPE = "application_type";
    private ApplicationType applicationType;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_ID_ISSUED_AT = "client_id_issued_at";
    private Integer clientIdIssuedAt;
    public static final String JSON_PROPERTY_CLIENT_NAME = "client_name";
    private String clientName;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private JsonNullable<String> clientSecret = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CLIENT_SECRET_EXPIRES_AT = "client_secret_expires_at";
    private JsonNullable<Integer> clientSecretExpiresAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FRONTCHANNEL_LOGOUT_SESSION_REQUIRED = "frontchannel_logout_session_required";
    private Boolean frontchannelLogoutSessionRequired;
    public static final String JSON_PROPERTY_FRONTCHANNEL_LOGOUT_URI = "frontchannel_logout_uri";
    private JsonNullable<String> frontchannelLogoutUri = JsonNullable.undefined();
    public static final String JSON_PROPERTY_GRANT_TYPES = "grant_types";
    private List<GrantType> grantTypes = null;
    public static final String JSON_PROPERTY_INITIATE_LOGIN_URI = "initiate_login_uri";
    private String initiateLoginUri;
    public static final String JSON_PROPERTY_JWKS_URI = "jwks_uri";
    private String jwksUri;
    public static final String JSON_PROPERTY_LOGO_URI = "logo_uri";
    private JsonNullable<String> logoUri = JsonNullable.undefined();
    public static final String JSON_PROPERTY_POLICY_URI = "policy_uri";
    private JsonNullable<String> policyUri = JsonNullable.undefined();
    public static final String JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS = "post_logout_redirect_uris";
    private List<String> postLogoutRedirectUris = null;
    public static final String JSON_PROPERTY_REDIRECT_URIS = "redirect_uris";
    private List<String> redirectUris = null;
    public static final String JSON_PROPERTY_REQUEST_OBJECT_SIGNING_ALG = "request_object_signing_alg";
    private List<SigningAlgorithm> requestObjectSigningAlg = null;
    public static final String JSON_PROPERTY_RESPONSE_TYPES = "response_types";
    private List<ResponseType> responseTypes = null;
    public static final String JSON_PROPERTY_TOKEN_ENDPOINT_AUTH_METHOD = "token_endpoint_auth_method";
    private EndpointAuthMethod tokenEndpointAuthMethod;
    public static final String JSON_PROPERTY_TOS_URI = "tos_uri";
    private JsonNullable<String> tosUri = JsonNullable.undefined();

    public Client applicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="application_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    @JsonProperty(value="application_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    @Nullable
    @ApiModelProperty(value="Unique key for the client application. The `client_id` is immutable. When you create a client Application, you can't specify the `client_id` because Okta uses the application ID for the `client_id`.")
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    @ApiModelProperty(value="Time at which the `client_id` was issued (measured in unix seconds)")
    @JsonProperty(value="client_id_issued_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getClientIdIssuedAt() {
        return this.clientIdIssuedAt;
    }

    public Client clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable string name of the client application")
    @JsonProperty(value="client_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientName() {
        return this.clientName;
    }

    @JsonProperty(value="client_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Nullable
    @ApiModelProperty(value="OAuth 2.0 client secret string (used for confidential clients). The `client_secret` is shown only on the response of the creation or update of a client Application (and only if the `token_endpoint_auth_method` is one that requires a client secret). You can't specify the `client_secret`. If the `token_endpoint_auth_method` requires one, Okta generates a random `client_secret` for the client Application.")
    @JsonIgnore
    public String getClientSecret() {
        if (this.clientSecret == null) {
            this.clientSecret = JsonNullable.undefined();
        }
        return (String)this.clientSecret.orElse(null);
    }

    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getClientSecret_JsonNullable() {
        return this.clientSecret;
    }

    @JsonProperty(value="client_secret")
    private void setClientSecret_JsonNullable(JsonNullable<String> clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Nullable
    @ApiModelProperty(value="Time at which the `client_secret` expires or 0 if it doesn't expire (measured in unix seconds)")
    @JsonIgnore
    public Integer getClientSecretExpiresAt() {
        if (this.clientSecretExpiresAt == null) {
            this.clientSecretExpiresAt = JsonNullable.undefined();
        }
        return (Integer)this.clientSecretExpiresAt.orElse(null);
    }

    @JsonProperty(value="client_secret_expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getClientSecretExpiresAt_JsonNullable() {
        return this.clientSecretExpiresAt;
    }

    @JsonProperty(value="client_secret_expires_at")
    private void setClientSecretExpiresAt_JsonNullable(JsonNullable<Integer> clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt;
    }

    public Client frontchannelLogoutSessionRequired(Boolean frontchannelLogoutSessionRequired) {
        this.frontchannelLogoutSessionRequired = frontchannelLogoutSessionRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Include user session details")
    @JsonProperty(value="frontchannel_logout_session_required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFrontchannelLogoutSessionRequired() {
        return this.frontchannelLogoutSessionRequired;
    }

    @JsonProperty(value="frontchannel_logout_session_required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFrontchannelLogoutSessionRequired(Boolean frontchannelLogoutSessionRequired) {
        this.frontchannelLogoutSessionRequired = frontchannelLogoutSessionRequired;
    }

    public Client frontchannelLogoutUri(String frontchannelLogoutUri) {
        this.frontchannelLogoutUri = JsonNullable.of((Object)frontchannelLogoutUri);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL where Okta sends the logout request")
    @JsonIgnore
    public String getFrontchannelLogoutUri() {
        return (String)this.frontchannelLogoutUri.orElse(null);
    }

    @JsonProperty(value="frontchannel_logout_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFrontchannelLogoutUri_JsonNullable() {
        return this.frontchannelLogoutUri;
    }

    @JsonProperty(value="frontchannel_logout_uri")
    public void setFrontchannelLogoutUri_JsonNullable(JsonNullable<String> frontchannelLogoutUri) {
        this.frontchannelLogoutUri = frontchannelLogoutUri;
    }

    public void setFrontchannelLogoutUri(String frontchannelLogoutUri) {
        this.frontchannelLogoutUri = JsonNullable.of((Object)frontchannelLogoutUri);
    }

    public Client grantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public Client addgrantTypesItem(GrantType grantTypesItem) {
        if (this.grantTypes == null) {
            this.grantTypes = new ArrayList<GrantType>();
        }
        this.grantTypes.add(grantTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of OAuth 2.0 grant type strings. Default value: `[authorization_code]`")
    @JsonProperty(value="grant_types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    @JsonProperty(value="grant_types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public Client initiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL that a third party can use to initiate a login by the client")
    @JsonProperty(value="initiate_login_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    @JsonProperty(value="initiate_login_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public Client jwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL string that references a [JSON Web Key Set](https://tools.ietf.org/html/rfc7517#section-5) for validating JWTs presented to Okta")
    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJwksUri() {
        return this.jwksUri;
    }

    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public Client logoUri(String logoUri) {
        this.logoUri = JsonNullable.of((Object)logoUri);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL string that references a logo for the client consent dialog (not the sign-in dialog)")
    @JsonIgnore
    public String getLogoUri() {
        return (String)this.logoUri.orElse(null);
    }

    @JsonProperty(value="logo_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLogoUri_JsonNullable() {
        return this.logoUri;
    }

    @JsonProperty(value="logo_uri")
    public void setLogoUri_JsonNullable(JsonNullable<String> logoUri) {
        this.logoUri = logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = JsonNullable.of((Object)logoUri);
    }

    public Client policyUri(String policyUri) {
        this.policyUri = JsonNullable.of((Object)policyUri);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL string of a web page providing the client's policy document")
    @JsonIgnore
    public String getPolicyUri() {
        return (String)this.policyUri.orElse(null);
    }

    @JsonProperty(value="policy_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPolicyUri_JsonNullable() {
        return this.policyUri;
    }

    @JsonProperty(value="policy_uri")
    public void setPolicyUri_JsonNullable(JsonNullable<String> policyUri) {
        this.policyUri = policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = JsonNullable.of((Object)policyUri);
    }

    public Client postLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
        return this;
    }

    public Client addpostLogoutRedirectUrisItem(String postLogoutRedirectUrisItem) {
        if (this.postLogoutRedirectUris == null) {
            this.postLogoutRedirectUris = new ArrayList<String>();
        }
        this.postLogoutRedirectUris.add(postLogoutRedirectUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of redirection URI strings for use for relying party initiated logouts")
    @JsonProperty(value="post_logout_redirect_uris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    @JsonProperty(value="post_logout_redirect_uris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public Client redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public Client addredirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of redirection URI strings for use in redirect-based flows. All redirect URIs must be absolute URIs and must not include a fragment component. At least one redirect URI and response type is required for all client types, with the following exceptions: If the client uses the Resource Owner Password flow (if `grant_type` contains the value password) or the Client Credentials flow (if `grant_type` contains the value `client_credentials`), then no redirect URI or response type is necessary. In these cases, you can pass either null or an empty array for these attributes.")
    @JsonProperty(value="redirect_uris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    @JsonProperty(value="redirect_uris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public Client requestObjectSigningAlg(List<SigningAlgorithm> requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
        return this;
    }

    public Client addrequestObjectSigningAlgItem(SigningAlgorithm requestObjectSigningAlgItem) {
        if (this.requestObjectSigningAlg == null) {
            this.requestObjectSigningAlg = new ArrayList<SigningAlgorithm>();
        }
        this.requestObjectSigningAlg.add(requestObjectSigningAlgItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of [JSON Web Key Set](https://tools.ietf.org/html/rfc7517#section-5) algorithm that must be used for signing request objects")
    @JsonProperty(value="request_object_signing_alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SigningAlgorithm> getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    @JsonProperty(value="request_object_signing_alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestObjectSigningAlg(List<SigningAlgorithm> requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public Client responseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
        return this;
    }

    public Client addresponseTypesItem(ResponseType responseTypesItem) {
        if (this.responseTypes == null) {
            this.responseTypes = new ArrayList<ResponseType>();
        }
        this.responseTypes.add(responseTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of OAuth 2.0 response type strings. Default value: `[code]`")
    @JsonProperty(value="response_types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    @JsonProperty(value="response_types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public Client tokenEndpointAuthMethod(EndpointAuthMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="token_endpoint_auth_method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EndpointAuthMethod getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    @JsonProperty(value="token_endpoint_auth_method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenEndpointAuthMethod(EndpointAuthMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public Client tosUri(String tosUri) {
        this.tosUri = JsonNullable.of((Object)tosUri);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL string of a web page providing the client's terms of service document")
    @JsonIgnore
    public String getTosUri() {
        return (String)this.tosUri.orElse(null);
    }

    @JsonProperty(value="tos_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTosUri_JsonNullable() {
        return this.tosUri;
    }

    @JsonProperty(value="tos_uri")
    public void setTosUri_JsonNullable(JsonNullable<String> tosUri) {
        this.tosUri = tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = JsonNullable.of((Object)tosUri);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client)o;
        return Objects.equals((Object)this.applicationType, (Object)client.applicationType) && Objects.equals(this.clientId, client.clientId) && Objects.equals(this.clientIdIssuedAt, client.clientIdIssuedAt) && Objects.equals(this.clientName, client.clientName) && Client.equalsNullable(this.clientSecret, client.clientSecret) && Client.equalsNullable(this.clientSecretExpiresAt, client.clientSecretExpiresAt) && Objects.equals(this.frontchannelLogoutSessionRequired, client.frontchannelLogoutSessionRequired) && Client.equalsNullable(this.frontchannelLogoutUri, client.frontchannelLogoutUri) && Objects.equals(this.grantTypes, client.grantTypes) && Objects.equals(this.initiateLoginUri, client.initiateLoginUri) && Objects.equals(this.jwksUri, client.jwksUri) && Client.equalsNullable(this.logoUri, client.logoUri) && Client.equalsNullable(this.policyUri, client.policyUri) && Objects.equals(this.postLogoutRedirectUris, client.postLogoutRedirectUris) && Objects.equals(this.redirectUris, client.redirectUris) && Objects.equals(this.requestObjectSigningAlg, client.requestObjectSigningAlg) && Objects.equals(this.responseTypes, client.responseTypes) && Objects.equals((Object)this.tokenEndpointAuthMethod, (Object)client.tokenEndpointAuthMethod) && Client.equalsNullable(this.tosUri, client.tosUri);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicationType, this.clientId, this.clientIdIssuedAt, this.clientName, Client.hashCodeNullable(this.clientSecret), Client.hashCodeNullable(this.clientSecretExpiresAt), this.frontchannelLogoutSessionRequired, Client.hashCodeNullable(this.frontchannelLogoutUri), this.grantTypes, this.initiateLoginUri, this.jwksUri, Client.hashCodeNullable(this.logoUri), Client.hashCodeNullable(this.policyUri), this.postLogoutRedirectUris, this.redirectUris, this.requestObjectSigningAlg, this.responseTypes, this.tokenEndpointAuthMethod, Client.hashCodeNullable(this.tosUri)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Client {\n");
        sb.append("    applicationType: ").append(this.toIndentedString((Object)this.applicationType)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientIdIssuedAt: ").append(this.toIndentedString(this.clientIdIssuedAt)).append("\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    clientSecretExpiresAt: ").append(this.toIndentedString(this.clientSecretExpiresAt)).append("\n");
        sb.append("    frontchannelLogoutSessionRequired: ").append(this.toIndentedString(this.frontchannelLogoutSessionRequired)).append("\n");
        sb.append("    frontchannelLogoutUri: ").append(this.toIndentedString(this.frontchannelLogoutUri)).append("\n");
        sb.append("    grantTypes: ").append(this.toIndentedString(this.grantTypes)).append("\n");
        sb.append("    initiateLoginUri: ").append(this.toIndentedString(this.initiateLoginUri)).append("\n");
        sb.append("    jwksUri: ").append(this.toIndentedString(this.jwksUri)).append("\n");
        sb.append("    logoUri: ").append(this.toIndentedString(this.logoUri)).append("\n");
        sb.append("    policyUri: ").append(this.toIndentedString(this.policyUri)).append("\n");
        sb.append("    postLogoutRedirectUris: ").append(this.toIndentedString(this.postLogoutRedirectUris)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    requestObjectSigningAlg: ").append(this.toIndentedString(this.requestObjectSigningAlg)).append("\n");
        sb.append("    responseTypes: ").append(this.toIndentedString(this.responseTypes)).append("\n");
        sb.append("    tokenEndpointAuthMethod: ").append(this.toIndentedString((Object)this.tokenEndpointAuthMethod)).append("\n");
        sb.append("    tosUri: ").append(this.toIndentedString(this.tosUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

