/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.AccessTokenKeyEncryptionAlgorithm;
import com.okta.sdk.resource.model.AuthServerLinks;
import com.okta.sdk.resource.model.AuthorizationServerCredentials;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.ResourceServerJsonWebKeys;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"accessTokenEncryptedResponseAlgorithm", "audiences", "created", "credentials", "description", "id", "issuer", "issuerMode", "jwks", "jwks_uri", "lastUpdated", "name", "status", "_links"})
public class AuthorizationServer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCESS_TOKEN_ENCRYPTED_RESPONSE_ALGORITHM = "accessTokenEncryptedResponseAlgorithm";
    private AccessTokenKeyEncryptionAlgorithm accessTokenEncryptedResponseAlgorithm;
    public static final String JSON_PROPERTY_AUDIENCES = "audiences";
    private List<String> audiences = null;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private AuthorizationServerCredentials credentials;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;
    public static final String JSON_PROPERTY_ISSUER_MODE = "issuerMode";
    private String issuerMode;
    public static final String JSON_PROPERTY_JWKS = "jwks";
    private ResourceServerJsonWebKeys jwks;
    public static final String JSON_PROPERTY_JWKS_URI = "jwks_uri";
    private String jwksUri;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private LifecycleStatus status;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private AuthServerLinks links;

    public AuthorizationServer accessTokenEncryptedResponseAlgorithm(AccessTokenKeyEncryptionAlgorithm accessTokenEncryptedResponseAlgorithm) {
        this.accessTokenEncryptedResponseAlgorithm = accessTokenEncryptedResponseAlgorithm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="accessTokenEncryptedResponseAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccessTokenKeyEncryptionAlgorithm getAccessTokenEncryptedResponseAlgorithm() {
        return this.accessTokenEncryptedResponseAlgorithm;
    }

    @JsonProperty(value="accessTokenEncryptedResponseAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessTokenEncryptedResponseAlgorithm(AccessTokenKeyEncryptionAlgorithm accessTokenEncryptedResponseAlgorithm) {
        this.accessTokenEncryptedResponseAlgorithm = accessTokenEncryptedResponseAlgorithm;
    }

    public AuthorizationServer audiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public AuthorizationServer addaudiencesItem(String audiencesItem) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(audiencesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The recipients that the tokens are intended for. This becomes the `aud` claim in an access token. Okta currently supports only one audience.")
    @JsonProperty(value="audiences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAudiences() {
        return this.audiences;
    }

    @JsonProperty(value="audiences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public AuthorizationServer credentials(AuthorizationServerCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthorizationServerCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(AuthorizationServerCredentials credentials) {
        this.credentials = credentials;
    }

    public AuthorizationServer description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The description of the custom authorization server")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the custom authorization server")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public AuthorizationServer issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The complete URL for the custom authorization server. This becomes the `iss` claim in an access token.")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public AuthorizationServer issuerMode(String issuerMode) {
        this.issuerMode = issuerMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates which value is specified in the issuer of the tokens that a custom authorization server returns: the Okta org domain URL or a custom domain URL.  `issuerMode` is visible if you have a custom URL domain configured or the Dynamic Issuer Mode feature enabled. If you have a custom URL domain configured, you can set a custom domain URL in a custom authorization server, and this property is returned in the appropriate responses.  When set to `ORG_URL`, then in responses, `issuer` is the Okta org domain URL: `https://${yourOktaDomain}`.  When set to `CUSTOM_URL`, then in responses, `issuer` is the custom domain URL configured in the administration user interface.  When set to `DYNAMIC`, then in responses, `issuer` is the custom domain URL if the OAuth 2.0 request was sent to the custom domain, or is the Okta org's domain URL if the OAuth 2.0 request was sent to the original Okta org domain.  After you configure a custom URL domain, all new custom authorization servers use `CUSTOM_URL` by default. If the Dynamic Issuer Mode feature is enabled, then all new custom authorization servers use `DYNAMIC` by default. All existing custom authorization servers continue to use the original value until they're changed using the Admin Console or the API. This way, existing integrations with the client and resource server continue to work after the feature is enabled.")
    @JsonProperty(value="issuerMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerMode() {
        return this.issuerMode;
    }

    @JsonProperty(value="issuerMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerMode(String issuerMode) {
        this.issuerMode = issuerMode;
    }

    public AuthorizationServer jwks(ResourceServerJsonWebKeys jwks) {
        this.jwks = jwks;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="jwks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceServerJsonWebKeys getJwks() {
        return this.jwks;
    }

    @JsonProperty(value="jwks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwks(ResourceServerJsonWebKeys jwks) {
        this.jwks = jwks;
    }

    public AuthorizationServer jwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="<x-lifecycle-container><x-lifecycle class=\"ea\"></x-lifecycle></x-lifecycle-container>URL string that references a JSON Web Key Set for encrypting JWTs minted by the custom authorization server")
    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJwksUri() {
        return this.jwksUri;
    }

    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public AuthorizationServer name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the custom authorization server")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public AuthorizationServer status(LifecycleStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifecycleStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    public AuthorizationServer links(AuthServerLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthServerLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(AuthServerLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationServer authorizationServer = (AuthorizationServer)o;
        return Objects.equals((Object)this.accessTokenEncryptedResponseAlgorithm, (Object)authorizationServer.accessTokenEncryptedResponseAlgorithm) && Objects.equals(this.audiences, authorizationServer.audiences) && Objects.equals(this.created, authorizationServer.created) && Objects.equals(this.credentials, authorizationServer.credentials) && Objects.equals(this.description, authorizationServer.description) && Objects.equals(this.id, authorizationServer.id) && Objects.equals(this.issuer, authorizationServer.issuer) && Objects.equals(this.issuerMode, authorizationServer.issuerMode) && Objects.equals(this.jwks, authorizationServer.jwks) && Objects.equals(this.jwksUri, authorizationServer.jwksUri) && Objects.equals(this.lastUpdated, authorizationServer.lastUpdated) && Objects.equals(this.name, authorizationServer.name) && Objects.equals((Object)this.status, (Object)authorizationServer.status) && Objects.equals(this.links, authorizationServer.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessTokenEncryptedResponseAlgorithm, this.audiences, this.created, this.credentials, this.description, this.id, this.issuer, this.issuerMode, this.jwks, this.jwksUri, this.lastUpdated, this.name, this.status, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationServer {\n");
        sb.append("    accessTokenEncryptedResponseAlgorithm: ").append(this.toIndentedString((Object)this.accessTokenEncryptedResponseAlgorithm)).append("\n");
        sb.append("    audiences: ").append(this.toIndentedString(this.audiences)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    issuerMode: ").append(this.toIndentedString(this.issuerMode)).append("\n");
        sb.append("    jwks: ").append(this.toIndentedString(this.jwks)).append("\n");
        sb.append("    jwksUri: ").append(this.toIndentedString(this.jwksUri)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

