/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AuthenticatorMethodType {
    CERT("cert"),
    DUO("duo"),
    EMAIL("email"),
    IDP("idp"),
    OTP("otp"),
    PASSWORD("password"),
    PUSH("push"),
    SECURITY_QUESTION("security_question"),
    SIGNED_NONCE("signed_nonce"),
    SMS("sms"),
    TOTP("totp"),
    VOICE("voice"),
    WEBAUTHN("webauthn"),
    TAC("tac"),
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    private AuthenticatorMethodType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static AuthenticatorMethodType fromValue(String value) {
        for (AuthenticatorMethodType b : AuthenticatorMethodType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString().toString());
    }
}

