/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="<div class=\"x-lifecycle-container\"><x-lifecycle class=\"oie\"></x-lifecycle></div> Universal Logout properties for the app. These properties are only returned and can't be updated.")
@JsonPropertyOrder(value={"identityStack", "protocol", "status", "supportType"})
public class ApplicationUniversalLogout
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_IDENTITY_STACK = "identityStack";
    private IdentityStackEnum identityStack;
    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    private ProtocolEnum protocol;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_SUPPORT_TYPE = "supportType";
    private SupportTypeEnum supportType;

    public ApplicationUniversalLogout identityStack(IdentityStackEnum identityStack) {
        this.identityStack = identityStack;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SHARED", value="Indicates whether the app uses a shared identity stack that may cause the user to sign out of other apps by the same company")
    @JsonProperty(value="identityStack")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IdentityStackEnum getIdentityStack() {
        return this.identityStack;
    }

    @JsonProperty(value="identityStack")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentityStack(IdentityStackEnum identityStack) {
        this.identityStack = identityStack;
    }

    public ApplicationUniversalLogout protocol(ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PROPRIETARY", value="The protocol used for Universal Logout")
    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public ApplicationUniversalLogout status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ENABLED", value="Universal Logout status for the app instance")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ApplicationUniversalLogout supportType(SupportTypeEnum supportType) {
        this.supportType = supportType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="FULL", value="Indicates whether the app supports full or partial Universal Logout (UL).")
    @JsonProperty(value="supportType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupportTypeEnum getSupportType() {
        return this.supportType;
    }

    @JsonProperty(value="supportType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportType(SupportTypeEnum supportType) {
        this.supportType = supportType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationUniversalLogout applicationUniversalLogout = (ApplicationUniversalLogout)o;
        return Objects.equals((Object)this.identityStack, (Object)applicationUniversalLogout.identityStack) && Objects.equals((Object)this.protocol, (Object)applicationUniversalLogout.protocol) && Objects.equals((Object)this.status, (Object)applicationUniversalLogout.status) && Objects.equals((Object)this.supportType, (Object)applicationUniversalLogout.supportType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identityStack, this.protocol, this.status, this.supportType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationUniversalLogout {\n");
        sb.append("    identityStack: ").append(this.toIndentedString((Object)this.identityStack)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString((Object)this.protocol)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    supportType: ").append(this.toIndentedString((Object)this.supportType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IdentityStackEnum {
        SHARED(String.valueOf("SHARED")),
        NOT_SHARED(String.valueOf("NOT_SHARED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private IdentityStackEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IdentityStackEnum fromValue(String value) {
            for (IdentityStackEnum b : IdentityStackEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ProtocolEnum {
        PROPRIETARY(String.valueOf("PROPRIETARY")),
        GLOBAL_TOKEN_REVOCATION(String.valueOf("GLOBAL_TOKEN_REVOCATION")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolEnum fromValue(String value) {
            for (ProtocolEnum b : ProtocolEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum StatusEnum {
        ENABLED(String.valueOf("ENABLED")),
        DISABLED(String.valueOf("DISABLED")),
        UNSUPPORTED(String.valueOf("UNSUPPORTED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum SupportTypeEnum {
        FULL(String.valueOf("FULL")),
        PARTIAL(String.valueOf("PARTIAL")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private SupportTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SupportTypeEnum fromValue(String value) {
            for (SupportTypeEnum b : SupportTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

