/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"description", "name", "ownerGroupIds", "ownerUserIds"})
public class AppServiceAccountForUpdate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER_GROUP_IDS = "ownerGroupIds";
    private List<String> ownerGroupIds = null;
    public static final String JSON_PROPERTY_OWNER_USER_IDS = "ownerUserIds";
    private List<String> ownerUserIds = null;

    public AppServiceAccountForUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is for accessing salesforce Prod-5", value="The description of the app service account")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public AppServiceAccountForUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="salesforce Prod-5 account", value="The user-defined name for the app service account")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public AppServiceAccountForUpdate ownerGroupIds(List<String> ownerGroupIds) {
        this.ownerGroupIds = ownerGroupIds;
        return this;
    }

    public AppServiceAccountForUpdate addownerGroupIdsItem(String ownerGroupIdsItem) {
        if (this.ownerGroupIds == null) {
            this.ownerGroupIds = new ArrayList<String>();
        }
        this.ownerGroupIds.add(ownerGroupIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"00g57qp78yZT2XBA40g7\"]", value="A list of IDs of the Okta groups who own the app service account")
    @JsonProperty(value="ownerGroupIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOwnerGroupIds() {
        return this.ownerGroupIds;
    }

    @JsonProperty(value="ownerGroupIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerGroupIds(List<String> ownerGroupIds) {
        this.ownerGroupIds = ownerGroupIds;
    }

    public AppServiceAccountForUpdate ownerUserIds(List<String> ownerUserIds) {
        this.ownerUserIds = ownerUserIds;
        return this;
    }

    public AppServiceAccountForUpdate addownerUserIdsItem(String ownerUserIdsItem) {
        if (this.ownerUserIds == null) {
            this.ownerUserIds = new ArrayList<String>();
        }
        this.ownerUserIds.add(ownerUserIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"00u11s48P9zGW8yqm0g5\"]", value="A list of IDs of the Okta users who own the app service account")
    @JsonProperty(value="ownerUserIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOwnerUserIds() {
        return this.ownerUserIds;
    }

    @JsonProperty(value="ownerUserIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerUserIds(List<String> ownerUserIds) {
        this.ownerUserIds = ownerUserIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppServiceAccountForUpdate appServiceAccountForUpdate = (AppServiceAccountForUpdate)o;
        return Objects.equals(this.description, appServiceAccountForUpdate.description) && Objects.equals(this.name, appServiceAccountForUpdate.name) && Objects.equals(this.ownerGroupIds, appServiceAccountForUpdate.ownerGroupIds) && Objects.equals(this.ownerUserIds, appServiceAccountForUpdate.ownerUserIds);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.ownerGroupIds, this.ownerUserIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppServiceAccountForUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerGroupIds: ").append(this.toIndentedString(this.ownerGroupIds)).append("\n");
        sb.append("    ownerUserIds: ").append(this.toIndentedString(this.ownerUserIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

