/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.DeviceIntegrity;
import com.okta.sdk.resource.model.PlayProtectVerdict;
import com.okta.sdk.resource.model.ScreenLockComplexity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Android Device Trust integration provider")
@JsonPropertyOrder(value={"deviceIntegrityLevel", "networkProxyDisabled", "playProtectVerdict", "requireMajorVersionUpdate", "screenLockComplexity", "usbDebuggingDisabled", "wifiSecured"})
public class AndroidDeviceTrust
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DEVICE_INTEGRITY_LEVEL = "deviceIntegrityLevel";
    private DeviceIntegrity deviceIntegrityLevel;
    public static final String JSON_PROPERTY_NETWORK_PROXY_DISABLED = "networkProxyDisabled";
    private Boolean networkProxyDisabled;
    public static final String JSON_PROPERTY_PLAY_PROTECT_VERDICT = "playProtectVerdict";
    private PlayProtectVerdict playProtectVerdict;
    public static final String JSON_PROPERTY_REQUIRE_MAJOR_VERSION_UPDATE = "requireMajorVersionUpdate";
    private Boolean requireMajorVersionUpdate;
    public static final String JSON_PROPERTY_SCREEN_LOCK_COMPLEXITY = "screenLockComplexity";
    private ScreenLockComplexity screenLockComplexity;
    public static final String JSON_PROPERTY_USB_DEBUGGING_DISABLED = "usbDebuggingDisabled";
    private Boolean usbDebuggingDisabled;
    public static final String JSON_PROPERTY_WIFI_SECURED = "wifiSecured";
    private Boolean wifiSecured;

    public AndroidDeviceTrust deviceIntegrityLevel(DeviceIntegrity deviceIntegrityLevel) {
        this.deviceIntegrityLevel = deviceIntegrityLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="deviceIntegrityLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeviceIntegrity getDeviceIntegrityLevel() {
        return this.deviceIntegrityLevel;
    }

    @JsonProperty(value="deviceIntegrityLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceIntegrityLevel(DeviceIntegrity deviceIntegrityLevel) {
        this.deviceIntegrityLevel = deviceIntegrityLevel;
    }

    public AndroidDeviceTrust networkProxyDisabled(Boolean networkProxyDisabled) {
        this.networkProxyDisabled = networkProxyDisabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether a device has a network proxy disabled")
    @JsonProperty(value="networkProxyDisabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNetworkProxyDisabled() {
        return this.networkProxyDisabled;
    }

    @JsonProperty(value="networkProxyDisabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkProxyDisabled(Boolean networkProxyDisabled) {
        this.networkProxyDisabled = networkProxyDisabled;
    }

    public AndroidDeviceTrust playProtectVerdict(PlayProtectVerdict playProtectVerdict) {
        this.playProtectVerdict = playProtectVerdict;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="playProtectVerdict")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlayProtectVerdict getPlayProtectVerdict() {
        return this.playProtectVerdict;
    }

    @JsonProperty(value="playProtectVerdict")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlayProtectVerdict(PlayProtectVerdict playProtectVerdict) {
        this.playProtectVerdict = playProtectVerdict;
    }

    public AndroidDeviceTrust requireMajorVersionUpdate(Boolean requireMajorVersionUpdate) {
        this.requireMajorVersionUpdate = requireMajorVersionUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the device needs to be on the latest major version available to the device  **Note:** This option requires an `osVersion.dynamicVersionRequirement` value to be supplied with the `osVersion.dynamicVersionRequirement.type` as either `MINIMUM` or `EXACT`. ")
    @JsonProperty(value="requireMajorVersionUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequireMajorVersionUpdate() {
        return this.requireMajorVersionUpdate;
    }

    @JsonProperty(value="requireMajorVersionUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequireMajorVersionUpdate(Boolean requireMajorVersionUpdate) {
        this.requireMajorVersionUpdate = requireMajorVersionUpdate;
    }

    public AndroidDeviceTrust screenLockComplexity(ScreenLockComplexity screenLockComplexity) {
        this.screenLockComplexity = screenLockComplexity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="screenLockComplexity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScreenLockComplexity getScreenLockComplexity() {
        return this.screenLockComplexity;
    }

    @JsonProperty(value="screenLockComplexity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScreenLockComplexity(ScreenLockComplexity screenLockComplexity) {
        this.screenLockComplexity = screenLockComplexity;
    }

    public AndroidDeviceTrust usbDebuggingDisabled(Boolean usbDebuggingDisabled) {
        this.usbDebuggingDisabled = usbDebuggingDisabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether Android Debug Bridge (adb) over USB is disabled")
    @JsonProperty(value="usbDebuggingDisabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUsbDebuggingDisabled() {
        return this.usbDebuggingDisabled;
    }

    @JsonProperty(value="usbDebuggingDisabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsbDebuggingDisabled(Boolean usbDebuggingDisabled) {
        this.usbDebuggingDisabled = usbDebuggingDisabled;
    }

    public AndroidDeviceTrust wifiSecured(Boolean wifiSecured) {
        this.wifiSecured = wifiSecured;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether a device is on a password-protected Wi-Fi network")
    @JsonProperty(value="wifiSecured")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getWifiSecured() {
        return this.wifiSecured;
    }

    @JsonProperty(value="wifiSecured")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWifiSecured(Boolean wifiSecured) {
        this.wifiSecured = wifiSecured;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidDeviceTrust androidDeviceTrust = (AndroidDeviceTrust)o;
        return Objects.equals((Object)this.deviceIntegrityLevel, (Object)androidDeviceTrust.deviceIntegrityLevel) && Objects.equals(this.networkProxyDisabled, androidDeviceTrust.networkProxyDisabled) && Objects.equals((Object)this.playProtectVerdict, (Object)androidDeviceTrust.playProtectVerdict) && Objects.equals(this.requireMajorVersionUpdate, androidDeviceTrust.requireMajorVersionUpdate) && Objects.equals((Object)this.screenLockComplexity, (Object)androidDeviceTrust.screenLockComplexity) && Objects.equals(this.usbDebuggingDisabled, androidDeviceTrust.usbDebuggingDisabled) && Objects.equals(this.wifiSecured, androidDeviceTrust.wifiSecured);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceIntegrityLevel, this.networkProxyDisabled, this.playProtectVerdict, this.requireMajorVersionUpdate, this.screenLockComplexity, this.usbDebuggingDisabled, this.wifiSecured});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AndroidDeviceTrust {\n");
        sb.append("    deviceIntegrityLevel: ").append(this.toIndentedString((Object)this.deviceIntegrityLevel)).append("\n");
        sb.append("    networkProxyDisabled: ").append(this.toIndentedString(this.networkProxyDisabled)).append("\n");
        sb.append("    playProtectVerdict: ").append(this.toIndentedString((Object)this.playProtectVerdict)).append("\n");
        sb.append("    requireMajorVersionUpdate: ").append(this.toIndentedString(this.requireMajorVersionUpdate)).append("\n");
        sb.append("    screenLockComplexity: ").append(this.toIndentedString((Object)this.screenLockComplexity)).append("\n");
        sb.append("    usbDebuggingDisabled: ").append(this.toIndentedString(this.usbDebuggingDisabled)).append("\n");
        sb.append("    wifiSecured: ").append(this.toIndentedString(this.wifiSecured)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

