/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Settings specific to the Okta Admin Console")
@JsonPropertyOrder(value={"sessionIdleTimeoutMinutes", "sessionMaxLifetimeMinutes"})
public class AdminConsoleSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_SESSION_IDLE_TIMEOUT_MINUTES = "sessionIdleTimeoutMinutes";
    private Integer sessionIdleTimeoutMinutes = 15;
    public static final String JSON_PROPERTY_SESSION_MAX_LIFETIME_MINUTES = "sessionMaxLifetimeMinutes";
    private Integer sessionMaxLifetimeMinutes = 720;

    public AdminConsoleSettings sessionIdleTimeoutMinutes(Integer sessionIdleTimeoutMinutes) {
        this.sessionIdleTimeoutMinutes = sessionIdleTimeoutMinutes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum idle time before the Okta Admin Console session expires. Must be no more than 12 hours.")
    @JsonProperty(value="sessionIdleTimeoutMinutes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSessionIdleTimeoutMinutes() {
        return this.sessionIdleTimeoutMinutes;
    }

    @JsonProperty(value="sessionIdleTimeoutMinutes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionIdleTimeoutMinutes(Integer sessionIdleTimeoutMinutes) {
        this.sessionIdleTimeoutMinutes = sessionIdleTimeoutMinutes;
    }

    public AdminConsoleSettings sessionMaxLifetimeMinutes(Integer sessionMaxLifetimeMinutes) {
        this.sessionMaxLifetimeMinutes = sessionMaxLifetimeMinutes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The absolute maximum session lifetime of the Okta Admin Console. Must be no more than 7 days.")
    @JsonProperty(value="sessionMaxLifetimeMinutes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSessionMaxLifetimeMinutes() {
        return this.sessionMaxLifetimeMinutes;
    }

    @JsonProperty(value="sessionMaxLifetimeMinutes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionMaxLifetimeMinutes(Integer sessionMaxLifetimeMinutes) {
        this.sessionMaxLifetimeMinutes = sessionMaxLifetimeMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminConsoleSettings adminConsoleSettings = (AdminConsoleSettings)o;
        return Objects.equals(this.sessionIdleTimeoutMinutes, adminConsoleSettings.sessionIdleTimeoutMinutes) && Objects.equals(this.sessionMaxLifetimeMinutes, adminConsoleSettings.sessionMaxLifetimeMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.sessionIdleTimeoutMinutes, this.sessionMaxLifetimeMinutes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminConsoleSettings {\n");
        sb.append("    sessionIdleTimeoutMinutes: ").append(this.toIndentedString(this.sessionIdleTimeoutMinutes)).append("\n");
        sb.append("    sessionMaxLifetimeMinutes: ").append(this.toIndentedString(this.sessionMaxLifetimeMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

