/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.APIServiceIntegrationSecretLinks;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"client_secret", "created", "id", "lastUpdated", "secret_hash", "status", "_links"})
public class APIServiceIntegrationInstanceSecret
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;
    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;
    public static final String JSON_PROPERTY_SECRET_HASH = "secret_hash";
    private String secretHash;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private APIServiceIntegrationSecretLinks links;

    @Nonnull
    @ApiModelProperty(example="DRUFXGF9XbLnS9k-Sla3x3POBiIxDreBCdZuFs5B", required=true, value="The OAuth 2.0 client secret string. The client secret string is returned in the response of a Secret creation request. In other responses (such as list, activate, or deactivate requests), the client secret is returned as an undisclosed hashed value.")
    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Nonnull
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", required=true, value="Timestamp when the API Service Integration instance Secret was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCreated() {
        return this.created;
    }

    @Nonnull
    @ApiModelProperty(example="ocs2f4zrZbs8nUa7p0g4", required=true, value="The ID of the API Service Integration instance Secret")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @Nonnull
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", required=true, value="Timestamp when the API Service Integration instance Secret was updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    @Nonnull
    @ApiModelProperty(example="yk4SVx4sUWVJVbHt6M-UPA", required=true, value="OAuth 2.0 client secret string hash")
    @JsonProperty(value="secret_hash")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSecretHash() {
        return this.secretHash;
    }

    public APIServiceIntegrationInstanceSecret status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ACTIVE", required=true, value="Status of the API Service Integration instance Secret")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public APIServiceIntegrationInstanceSecret links(APIServiceIntegrationSecretLinks links) {
        this.links = links;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public APIServiceIntegrationSecretLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLinks(APIServiceIntegrationSecretLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIServiceIntegrationInstanceSecret apIServiceIntegrationInstanceSecret = (APIServiceIntegrationInstanceSecret)o;
        return Objects.equals(this.clientSecret, apIServiceIntegrationInstanceSecret.clientSecret) && Objects.equals(this.created, apIServiceIntegrationInstanceSecret.created) && Objects.equals(this.id, apIServiceIntegrationInstanceSecret.id) && Objects.equals(this.lastUpdated, apIServiceIntegrationInstanceSecret.lastUpdated) && Objects.equals(this.secretHash, apIServiceIntegrationInstanceSecret.secretHash) && Objects.equals((Object)this.status, (Object)apIServiceIntegrationInstanceSecret.status) && Objects.equals(this.links, apIServiceIntegrationInstanceSecret.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientSecret, this.created, this.id, this.lastUpdated, this.secretHash, this.status, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIServiceIntegrationInstanceSecret {\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    secretHash: ").append(this.toIndentedString(this.secretHash)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

