/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains additional properties about custom AAGUID.")
@JsonPropertyOrder(value={"fipsCompliant", "hardwareProtected", "platformAttached"})
public class AAGUIDAuthenticatorCharacteristics
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_FIPS_COMPLIANT = "fipsCompliant";
    private Boolean fipsCompliant;
    public static final String JSON_PROPERTY_HARDWARE_PROTECTED = "hardwareProtected";
    private Boolean hardwareProtected;
    public static final String JSON_PROPERTY_PLATFORM_ATTACHED = "platformAttached";
    private Boolean platformAttached;

    public AAGUIDAuthenticatorCharacteristics fipsCompliant(Boolean fipsCompliant) {
        this.fipsCompliant = fipsCompliant;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the authenticator meets Federal Information Processing Standards (FIPS) compliance requirements")
    @JsonProperty(value="fipsCompliant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFipsCompliant() {
        return this.fipsCompliant;
    }

    @JsonProperty(value="fipsCompliant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFipsCompliant(Boolean fipsCompliant) {
        this.fipsCompliant = fipsCompliant;
    }

    public AAGUIDAuthenticatorCharacteristics hardwareProtected(Boolean hardwareProtected) {
        this.hardwareProtected = hardwareProtected;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the authenticator stores the private key on a hardware component")
    @JsonProperty(value="hardwareProtected")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHardwareProtected() {
        return this.hardwareProtected;
    }

    @JsonProperty(value="hardwareProtected")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHardwareProtected(Boolean hardwareProtected) {
        this.hardwareProtected = hardwareProtected;
    }

    public AAGUIDAuthenticatorCharacteristics platformAttached(Boolean platformAttached) {
        this.platformAttached = platformAttached;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the custom AAGUID is built into the authenticator (`true`) or if it's a separate, external authenticator")
    @JsonProperty(value="platformAttached")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPlatformAttached() {
        return this.platformAttached;
    }

    @JsonProperty(value="platformAttached")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformAttached(Boolean platformAttached) {
        this.platformAttached = platformAttached;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AAGUIDAuthenticatorCharacteristics aaGUIDAuthenticatorCharacteristics = (AAGUIDAuthenticatorCharacteristics)o;
        return Objects.equals(this.fipsCompliant, aaGUIDAuthenticatorCharacteristics.fipsCompliant) && Objects.equals(this.hardwareProtected, aaGUIDAuthenticatorCharacteristics.hardwareProtected) && Objects.equals(this.platformAttached, aaGUIDAuthenticatorCharacteristics.platformAttached);
    }

    public int hashCode() {
        return Objects.hash(this.fipsCompliant, this.hardwareProtected, this.platformAttached);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AAGUIDAuthenticatorCharacteristics {\n");
        sb.append("    fipsCompliant: ").append(this.toIndentedString(this.fipsCompliant)).append("\n");
        sb.append("    hardwareProtected: ").append(this.toIndentedString(this.hardwareProtected)).append("\n");
        sb.append("    platformAttached: ").append(this.toIndentedString(this.platformAttached)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

