/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.client;

import com.okta.commons.lang.Collections;
import com.okta.sdk.resource.client.ApiResponse;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PagedIterator<T>
implements Iterator<T> {
    private static final Pattern NEXT_LINK_PATTERN = Pattern.compile("<([^>]+)>;\\s*rel=\"next\"");
    private final Function<String, ApiResponse<List<T>>> pageFetcher;
    private String nextUrl = null;
    private boolean isFirstPage = true;
    private Queue<T> itemBuffer = new LinkedList<T>();

    public PagedIterator(Function<String, ApiResponse<List<T>>> pageFetcher) {
        this.pageFetcher = pageFetcher;
    }

    @Override
    public boolean hasNext() {
        if (!this.itemBuffer.isEmpty()) {
            return true;
        }
        if (this.isFirstPage || this.nextUrl != null) {
            this.fetchNextPage();
        }
        return !this.itemBuffer.isEmpty();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more items in pagination.");
        }
        return this.itemBuffer.poll();
    }

    private void fetchNextPage() {
        ApiResponse<List<T>> response = this.pageFetcher.apply(this.isFirstPage ? null : this.nextUrl);
        if (response.getBody() != null) {
            this.itemBuffer.addAll((Collection)response.getBody());
        }
        this.nextUrl = this.parseNextLinkFromHeaders(response.getHeaders());
        this.isFirstPage = false;
    }

    private String parseNextLinkFromHeaders(Map<String, List<String>> headers) {
        if (headers == null) {
            return null;
        }
        List<String> linkHeaders = headers.get("Link");
        if (Collections.isEmpty(linkHeaders)) {
            linkHeaders = headers.get("link");
        }
        if (Collections.isEmpty(linkHeaders)) {
            return null;
        }
        for (String linkHeader : linkHeaders) {
            Matcher matcher = NEXT_LINK_PATTERN.matcher(linkHeader);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return null;
    }
}

