/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.cache.Cache;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.cache.Caches;
import com.okta.sdk.client.MultiThreadingWarningUtil;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiResponse;
import com.okta.sdk.resource.client.JavaTimeFormatter;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.client.RFC3339DateFormat;
import com.okta.sdk.resource.client.ServerConfiguration;
import com.okta.sdk.resource.client.ServerVariable;
import com.okta.sdk.resource.client.auth.ApiKeyAuth;
import com.okta.sdk.resource.client.auth.Authentication;
import com.okta.sdk.resource.client.auth.HttpBearerAuth;
import com.okta.sdk.resource.client.auth.OAuth;
import com.okta.sdk.resource.common.PagedList;
import com.okta.sdk.resource.model.HttpMethod;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiClient
extends JavaTimeFormatter {
    private static final Logger log = LoggerFactory.getLogger(ApiClient.class);
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private Map<String, String> defaultCookieMap = new HashMap<String, String>();
    private String basePath = "https://subdomain.okta.com";
    protected List<ServerConfiguration> servers = new ArrayList<ServerConfiguration>(Arrays.asList(new ServerConfiguration("https://{yourOktaDomain}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
        {
            this.put("yourOktaDomain", new ServerVariable("The domain of your organization. This can be a provided subdomain of an official okta domain (okta.com, oktapreview.com, etc) or one of your configured custom domains.", "subdomain.okta.com", new HashSet<String>()));
        }
    })));
    protected Integer serverIndex = 0;
    protected Map<String, String> serverVariables = null;
    private boolean debugging = false;
    private int connectionTimeout = 0;
    private CloseableHttpClient httpClient;
    private ObjectMapper objectMapper;
    protected String tempFolderPath = null;
    private Map<String, Authentication> authentications;
    private CacheManager cacheManager;
    private Cache<String, Object> defaultCache;
    private static final ThreadLocal<Integer> lastStatusCode = new ThreadLocal();
    private static final ThreadLocal<Map<String, List<String>>> lastResponseHeaders = new ThreadLocal();
    private final MultiThreadingWarningUtil multiThreadingWarningUtil = new MultiThreadingWarningUtil();
    private DateFormat dateFormat;
    private static List<String> bodyMethods = Arrays.asList("POST", "PUT", "DELETE", "PATCH");

    public ApiClient(CloseableHttpClient httpClient, CacheManager cacheManager) {
        if (httpClient == null) {
            throw new IllegalArgumentException("httpClient cannot be null");
        }
        if (cacheManager == null) {
            throw new IllegalArgumentException("cacheManager cannot be null");
        }
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        this.objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.registerModule((Module)new JsonNullableModule());
        this.objectMapper.setDateFormat(ApiClient.buildDefaultDateFormat());
        this.dateFormat = ApiClient.buildDefaultDateFormat();
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("apiToken", new ApiKeyAuth("header", "Authorization"));
        this.authentications.put("oauth2", new OAuth());
        this.authentications = Collections.unmodifiableMap(this.authentications);
        this.httpClient = httpClient;
        this.cacheManager = cacheManager;
        this.defaultCache = cacheManager.getCache("default");
    }

    public ApiClient() {
        this(HttpClients.createDefault(), Caches.newDisabledCacheManager());
    }

    public static DateFormat buildDefaultDateFormat() {
        return new RFC3339DateFormat();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ApiClient setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        this.serverIndex = null;
        return this;
    }

    public List<ServerConfiguration> getServers() {
        return this.servers;
    }

    public ApiClient setServers(List<ServerConfiguration> servers) {
        this.servers = servers;
        return this;
    }

    public Integer getServerIndex() {
        return this.serverIndex;
    }

    public ApiClient setServerIndex(Integer serverIndex) {
        this.serverIndex = serverIndex;
        return this;
    }

    public Map<String, String> getServerVariables() {
        return this.serverVariables;
    }

    public ApiClient setServerVariables(Map<String, String> serverVariables) {
        this.serverVariables = serverVariables;
        return this;
    }

    @Deprecated(forRemoval=true, since="24.1.0")
    public int getStatusCode() {
        Integer statusCode = lastStatusCode.get();
        return statusCode != null ? statusCode : 0;
    }

    @Deprecated(forRemoval=true, since="24.1.0")
    public Map<String, List<String>> getResponseHeaders() {
        Map<String, List<String>> headers = lastResponseHeaders.get();
        return headers != null ? headers : Collections.emptyMap();
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void replaceAuthentication(String authName, Authentication authentication) {
        Authentication previous = this.authentications.get(authName);
        if (previous == null) {
            throw new RuntimeException(authName + " authentication not configured!");
        }
        if (!previous.getClass().isAssignableFrom(authentication.getClass())) {
            throw new RuntimeException(authentication.getClass().getSimpleName() + " cannot replace authentication " + authName);
        }
        this.authentications = new HashMap<String, Authentication>(this.authentications);
        this.authentications.put(authName, authentication);
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return this;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public ApiClient setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return this;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public ApiClient setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public final ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public ApiClient addDefaultCookie(String key, String value) {
        this.defaultCookieMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectionTimeout;
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.objectMapper.setDateFormat((DateFormat)dateFormat.clone());
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof OffsetDateTime) {
            return this.formatOffsetDateTime((OffsetDateTime)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPair(String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value instanceof Collection) {
            return params;
        }
        params.add(new Pair(name, this.escapeString(this.parameterToString(value))));
        return params;
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Collection<?> value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value.isEmpty()) {
            return params;
        }
        if ("multi".equals(collectionFormat)) {
            for (Object item : value) {
                params.add(new Pair(name, this.escapeString(this.parameterToString(item))));
            }
            return params;
        }
        String delimiter = ",";
        if ("ssv".equals(collectionFormat)) {
            delimiter = this.escapeString(" ");
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = this.escapeString("\t");
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = this.escapeString("|");
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : value) {
            sb.append(delimiter);
            sb.append(this.escapeString(this.parameterToString(item)));
        }
        params.add(new Pair(name, sb.substring(delimiter.length())));
        return params;
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts, String path) {
        if (path != null && path.contains("/sso/saml/metadata")) {
            for (String accept : accepts) {
                if (!"text/xml".equalsIgnoreCase(accept)) continue;
                return accept;
            }
        }
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtils.join((Object[])accepts, (String)",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0 || contentTypes[0].equals("*/*")) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!contentType.contains("multipart/form-data")) continue;
            return contentType;
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    protected Map<String, List<String>> transformResponseHeaders(Header[] headers) {
        HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
        for (Header header : headers) {
            ArrayList<String> valuesList = (ArrayList<String>)headersMap.get(header.getName());
            if (valuesList != null) {
                valuesList.add(header.getValue());
                continue;
            }
            valuesList = new ArrayList<String>();
            valuesList.add(header.getValue());
            headersMap.put(header.getName(), valuesList);
        }
        return headersMap;
    }

    private ContentType getContentType(String headerValue) throws ApiException {
        try {
            return ContentType.parse((CharSequence)headerValue);
        }
        catch (UnsupportedCharsetException e) {
            throw new ApiException("Could not parse content type " + headerValue);
        }
    }

    private String getResponseMimeType(HttpResponse response) throws ApiException {
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            return this.getContentType(contentTypeHeader.getValue()).getMimeType();
        }
        return null;
    }

    public HttpEntity serialize(Object obj, Map<String, Object> formParams, ContentType contentType) throws ApiException {
        String mimeType = contentType.getMimeType();
        if (this.isJsonMime(mimeType)) {
            try {
                return new StringEntity(this.objectMapper.writeValueAsString(obj), contentType.withCharset(StandardCharsets.UTF_8));
            }
            catch (JsonProcessingException e) {
                throw new ApiException(e);
            }
        }
        if (mimeType.equals(ContentType.MULTIPART_FORM_DATA.getMimeType())) {
            MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
            for (Map.Entry<String, Object> paramEntry : formParams.entrySet()) {
                Object value = paramEntry.getValue();
                if (value instanceof File) {
                    multiPartBuilder.addBinaryBody(paramEntry.getKey(), (File)value);
                    continue;
                }
                if (value instanceof byte[]) {
                    multiPartBuilder.addBinaryBody(paramEntry.getKey(), (byte[])value);
                    continue;
                }
                Charset charset = contentType.getCharset();
                if (charset != null) {
                    ContentType customContentType = ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (Charset)charset);
                    multiPartBuilder.addTextBody(paramEntry.getKey(), this.parameterToString(paramEntry.getValue()), customContentType);
                    continue;
                }
                multiPartBuilder.addTextBody(paramEntry.getKey(), this.parameterToString(paramEntry.getValue()));
            }
            return multiPartBuilder.build();
        }
        if (mimeType.equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
            ArrayList<BasicNameValuePair> formValues = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> paramEntry : formParams.entrySet()) {
                formValues.add(new BasicNameValuePair(paramEntry.getKey(), this.parameterToString(paramEntry.getValue())));
            }
            return new UrlEncodedFormEntity(formValues, contentType.getCharset());
        }
        if (obj instanceof File) {
            return new FileEntity((File)obj, contentType);
        }
        if (obj instanceof byte[]) {
            return new ByteArrayEntity((byte[])obj, contentType);
        }
        throw new ApiException("Serialization for content type '" + String.valueOf(contentType) + "' not supported");
    }

    public <T> T deserialize(CloseableHttpResponse response, TypeReference<T> valueType) throws ApiException, IOException, org.apache.hc.core5.http.ParseException {
        if (valueType == null) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        Type valueRawType = valueType.getType();
        if (valueRawType.equals(byte[].class)) {
            return (T)EntityUtils.toByteArray((HttpEntity)entity);
        }
        if (valueRawType.equals(File.class)) {
            return (T)this.downloadFileFromResponse(response);
        }
        String mimeType = this.getResponseMimeType((HttpResponse)response);
        if (mimeType == null || this.isJsonMime(mimeType)) {
            Object value;
            String content = EntityUtils.toString((HttpEntity)entity);
            if ("".equals(content)) {
                return null;
            }
            if (valueRawType.getTypeName().contains("java.util.List") && content.startsWith("{\"")) {
                content = content.substring(content.indexOf(":") + 1);
                content = content.substring(0, content.length() - 1);
            }
            return (T)((value = this.objectMapper.readValue(content, valueType)) instanceof List ? PagedList.constructPagedList((HttpResponse)response, value) : value);
        }
        if ("text/plain".equalsIgnoreCase(mimeType)) {
            return (T)EntityUtils.toString((HttpEntity)entity);
        }
        if ("text/xml".equalsIgnoreCase(mimeType)) {
            return (T)EntityUtils.toString((HttpEntity)entity);
        }
        Map<String, List<String>> responseHeaders = this.transformResponseHeaders(response.getHeaders());
        throw new ApiException("Deserialization for content type '" + mimeType + "' not supported for type '" + String.valueOf(valueType) + "'", response.getCode(), responseHeaders, EntityUtils.toString((HttpEntity)entity));
    }

    private File downloadFileFromResponse(CloseableHttpResponse response) throws IOException {
        Header contentDispositionHeader = response.getFirstHeader("Content-Disposition");
        String contentDisposition = contentDispositionHeader == null ? null : contentDispositionHeader.getValue();
        File file = this.prepareDownloadFile(contentDisposition);
        Files.copy(response.getEntity().getContent(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return file;
    }

    protected File prepareDownloadFile(String contentDisposition) throws IOException {
        Object prefix;
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = matcher.group(1);
        }
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (((String)prefix).length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return Files.createTempFile((String)prefix, suffix, new FileAttribute[0]).toFile();
        }
        return Files.createTempFile(Paths.get(this.tempFolderPath, new String[0]), (String)prefix, suffix, new FileAttribute[0]).toFile();
    }

    public String getBaseURL() {
        String baseURL;
        if (this.serverIndex != null) {
            if (this.serverIndex < 0 || this.serverIndex >= this.servers.size()) {
                throw new ArrayIndexOutOfBoundsException(String.format("Invalid index %d when selecting the host settings. Must be less than %d", this.serverIndex, this.servers.size()));
            }
            baseURL = this.servers.get(this.serverIndex).URL(this.serverVariables);
        } else {
            baseURL = this.basePath;
        }
        return baseURL;
    }

    private String buildUrl(String path, List<Pair> queryParams, List<Pair> collectionQueryParams, String urlQueryDeepObject) {
        String value;
        String prefix;
        String baseURL = this.getBaseURL();
        StringBuilder url = new StringBuilder();
        url.append(baseURL).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(value);
            }
        }
        if (collectionQueryParams != null && !collectionQueryParams.isEmpty()) {
            prefix = url.toString().contains("?") ? "&" : "?";
            for (Pair param : collectionQueryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(value);
            }
        }
        if (urlQueryDeepObject != null && urlQueryDeepObject.length() > 0) {
            url.append(url.toString().contains("?") ? "&" : "?");
            url.append(urlQueryDeepObject);
        }
        return url.toString();
    }

    protected boolean isSuccessfulStatus(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    protected boolean isBodyAllowed(String method) {
        return bodyMethods.contains(method);
    }

    protected Cookie buildCookie(String key, String value, URI uri) {
        BasicClientCookie cookie = new BasicClientCookie(key, value);
        cookie.setDomain(uri.getHost());
        cookie.setPath("/");
        return cookie;
    }

    protected <T> T processResponse(CloseableHttpResponse response, TypeReference<T> returnType) throws ApiException, IOException, org.apache.hc.core5.http.ParseException {
        int statusCode = response.getCode();
        this.multiThreadingWarningUtil.recordThreadAccess();
        lastStatusCode.set(statusCode);
        if (statusCode == 204) {
            return null;
        }
        Map<String, List<String>> responseHeaders = this.transformResponseHeaders(response.getHeaders());
        lastResponseHeaders.set(responseHeaders);
        if (this.isSuccessfulStatus(statusCode)) {
            return this.deserialize(response, returnType);
        }
        String message = EntityUtils.toString((HttpEntity)response.getEntity());
        throw new ApiException(message, statusCode, responseHeaders, message);
    }

    protected <T> ApiResponse<T> processResponseWithHttpInfo(CloseableHttpResponse response, TypeReference<T> returnType) throws ApiException, IOException, org.apache.hc.core5.http.ParseException {
        int statusCode = response.getCode();
        Map<String, List<String>> responseHeaders = this.transformResponseHeaders(response.getHeaders());
        if (statusCode == 204) {
            return new ApiResponse<Object>(statusCode, responseHeaders, null);
        }
        if (this.isSuccessfulStatus(statusCode)) {
            T body = this.deserialize(response, returnType);
            return new ApiResponse<T>(statusCode, responseHeaders, body);
        }
        String message = EntityUtils.toString((HttpEntity)response.getEntity());
        throw new ApiException(message, statusCode, responseHeaders, message);
    }

    public <T> ApiResponse<T> invokeAPIWithHttpInfoFullURL(String fullUrl, String method, Map<String, String> headerParams, String accept, String contentType, String[] authNames, TypeReference<T> returnType) throws ApiException {
        ApiResponse<T> apiResponse;
        block11: {
            this.updateParamsForAuth(authNames, new ArrayList<Pair>(), headerParams, new HashMap<String, String>());
            ClassicRequestBuilder builder = ClassicRequestBuilder.create((String)method);
            builder.setUri(fullUrl);
            if (accept != null) {
                builder.addHeader("Accept", accept);
            }
            for (Map.Entry<String, String> keyValue : headerParams.entrySet()) {
                builder.addHeader(keyValue.getKey(), keyValue.getValue());
            }
            for (Map.Entry<String, String> keyValue : this.defaultHeaderMap.entrySet()) {
                if (headerParams.containsKey(keyValue.getKey())) continue;
                builder.addHeader(keyValue.getKey(), keyValue.getValue());
            }
            ContentType contentTypeObj = this.getContentType(contentType);
            builder.setEntity((HttpEntity)new StringEntity("", contentTypeObj));
            CloseableHttpResponse response = this.httpClient.execute(builder.build());
            try {
                apiResponse = this.processResponseWithHttpInfo(response, returnType);
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | org.apache.hc.core5.http.ParseException e) {
                    throw new ApiException(e);
                }
            }
            response.close();
        }
        return apiResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> ApiResponse<T> invokeAPIWithHttpInfo(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, String urlQueryDeepObject, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, TypeReference<T> returnType) throws ApiException {
        ApiResponse<T> apiResponse;
        if (body != null && !formParams.isEmpty()) {
            throw new ApiException("Cannot have body and form params");
        }
        this.updateParamsForAuth(authNames, queryParams, headerParams, cookieParams);
        String url = this.buildUrl(path, queryParams, collectionQueryParams, urlQueryDeepObject);
        ClassicRequestBuilder builder = ClassicRequestBuilder.create((String)method);
        builder.setUri(url);
        if (accept != null) {
            builder.addHeader("Accept", accept);
        }
        for (Map.Entry<String, String> entry : headerParams.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(entry.getKey())) continue;
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        BasicCookieStore store = new BasicCookieStore();
        for (Map.Entry<String, String> keyValue : cookieParams.entrySet()) {
            store.addCookie(this.buildCookie(keyValue.getKey(), keyValue.getValue(), builder.getUri()));
        }
        for (Map.Entry<String, String> keyValue : this.defaultCookieMap.entrySet()) {
            if (cookieParams.containsKey(keyValue.getKey())) continue;
            store.addCookie(this.buildCookie(keyValue.getKey(), keyValue.getValue(), builder.getUri()));
        }
        HttpClientContext httpClientContext = HttpClientContext.create();
        httpClientContext.setCookieStore((CookieStore)store);
        ContentType contentTypeObj = this.getContentType(contentType);
        if (body != null || !formParams.isEmpty()) {
            if (!this.isBodyAllowed(method)) throw new ApiException("method " + method + " does not support a request body");
            builder.setEntity(this.serialize(body, formParams, contentTypeObj));
        } else {
            builder.setEntity((HttpEntity)new StringEntity("", contentTypeObj));
        }
        CloseableHttpResponse response = this.httpClient.execute(builder.build(), (HttpContext)httpClientContext);
        try {
            apiResponse = this.processResponseWithHttpInfo(response, returnType);
            if (response == null) return apiResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response == null) throw throwable;
                try {
                    response.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | org.apache.hc.core5.http.ParseException e) {
                throw new ApiException(e);
            }
        }
        response.close();
        return apiResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T invokeAPI(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, String urlQueryDeepObject, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, TypeReference<T> returnType) throws ApiException {
        Cache resourceCache3;
        Class expectedType;
        Cache<String, Object> cache;
        CharSequence[] uriSegments;
        String cacheKey;
        HttpClientContext httpClientContext;
        ClassicRequestBuilder builder;
        String url;
        block70: {
            if (body != null && !formParams.isEmpty()) {
                throw new ApiException("Cannot have body and form params");
            }
            this.updateParamsForAuth(authNames, queryParams, headerParams, cookieParams);
            url = this.buildUrl(path, queryParams, collectionQueryParams, urlQueryDeepObject);
            builder = ClassicRequestBuilder.create((String)method);
            builder.setUri(url);
            if (accept != null) {
                builder.addHeader("Accept", accept);
            }
            for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.defaultHeaderMap.entrySet()) {
                if (headerParams.containsKey(entry.getKey())) continue;
                builder.addHeader(entry.getKey(), entry.getValue());
            }
            BasicCookieStore store = new BasicCookieStore();
            for (Map.Entry<String, String> keyValue : cookieParams.entrySet()) {
                store.addCookie(this.buildCookie(keyValue.getKey(), keyValue.getValue(), builder.getUri()));
            }
            for (Map.Entry<String, String> keyValue : this.defaultCookieMap.entrySet()) {
                if (cookieParams.containsKey(keyValue.getKey())) continue;
                store.addCookie(this.buildCookie(keyValue.getKey(), keyValue.getValue(), builder.getUri()));
            }
            httpClientContext = HttpClientContext.create();
            httpClientContext.setCookieStore((CookieStore)store);
            ContentType contentTypeObj = this.getContentType(contentType);
            if (body != null || !formParams.isEmpty()) {
                if (!this.isBodyAllowed(method)) throw new ApiException("method " + method + " does not support a request body");
                builder.setEntity(this.serialize(body, formParams, contentTypeObj));
            } else {
                builder.setEntity((HttpEntity)new StringEntity("", contentTypeObj));
            }
            cacheKey = url;
            if (Objects.nonNull(path)) {
                cacheKey = cacheKey.split("\\?")[0];
            }
            uriSegments = path.split("/");
            cache = this.defaultCache;
            expectedType = null;
            if (returnType != null && returnType.getType() instanceof Class) {
                expectedType = (Class)returnType.getType();
                try {
                    cache = this.cacheManager.getCache(expectedType.getName());
                }
                catch (Exception e) {
                    cache = this.defaultCache;
                }
            }
            if (!method.equals(HttpMethod.GET.name())) {
                try {
                    log.debug("Invalidating cache for {} {}", (Object)method, (Object)cacheKey);
                    log.debug("Path: {}", (Object)path);
                    log.debug("Current cache: {}", (Object)cache.getClass().getName());
                    cache.remove(cacheKey);
                    log.debug("Removed from current cache");
                    if (cache != this.defaultCache) {
                        this.defaultCache.remove(cacheKey);
                        log.debug("Removed from default cache");
                    }
                    ArrayList<String> resourceCacheNames = new ArrayList<String>();
                    if (path.contains("/push-mappings/") || path.contains("/group-push/mappings/")) {
                        resourceCacheNames.add("com.okta.sdk.resource.model.GroupPushMapping");
                    }
                    if (path.contains("/federated-claims/") || path.contains("/claims/")) {
                        resourceCacheNames.add("com.okta.sdk.resource.model.FederatedClaim");
                        resourceCacheNames.add("com.okta.sdk.resource.model.FederatedClaimRequestBody");
                    }
                    if (path.contains("/users/")) {
                        resourceCacheNames.add("com.okta.sdk.resource.model.User");
                    }
                    if (path.contains("/policies/")) {
                        resourceCacheNames.add("com.okta.sdk.resource.model.Policy");
                    }
                    if (path.contains("/apps/")) {
                        resourceCacheNames.add("com.okta.sdk.resource.model.Application");
                    }
                    if (path.contains("/groups/")) {
                        resourceCacheNames.add("com.okta.sdk.resource.model.Group");
                    }
                    for (String resourceCacheName : resourceCacheNames) {
                        try {
                            Cache resourceCache2 = this.cacheManager.getCache(resourceCacheName);
                            resourceCache2.remove(cacheKey);
                        }
                        catch (Exception resourceCache2) {}
                    }
                }
                catch (Exception resourceCacheNames) {
                    // empty catch block
                }
                try {
                    String primaryResource;
                    if (uriSegments.length < 5) break block70;
                    String resourceCacheName = null;
                    String string = primaryResource = uriSegments.length > 3 ? uriSegments[3] : null;
                    if ("users".equals(primaryResource)) {
                        resourceCacheName = "com.okta.sdk.resource.model.User";
                    } else if ("policies".equals(primaryResource)) {
                        resourceCacheName = "com.okta.sdk.resource.model.Policy";
                    } else if ("apps".equals(primaryResource)) {
                        resourceCacheName = "com.okta.sdk.resource.model.Application";
                    } else if ("groups".equals(primaryResource)) {
                        resourceCacheName = "com.okta.sdk.resource.model.Group";
                    } else if ("push-mappings".equals(primaryResource)) {
                        resourceCacheName = "com.okta.sdk.resource.model.GroupPushMapping";
                    } else if ("claims".equals(primaryResource)) {
                        resourceCacheName = "com.okta.sdk.resource.model.FederatedClaim";
                    }
                    String parentPath = "/" + (String)uriSegments[1] + "/" + (String)uriSegments[2] + "/" + (String)uriSegments[3] + "/" + (String)uriSegments[4];
                    String parentKey = url.substring(0, url.indexOf(path)) + parentPath;
                    try {
                        cache.remove(parentKey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cache != this.defaultCache) {
                        try {
                            this.defaultCache.remove(parentKey);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (resourceCacheName != null) {
                        try {
                            resourceCache3 = this.cacheManager.getCache(resourceCacheName);
                            resourceCache3.remove((CallSite)((Object)parentKey));
                        }
                        catch (Exception resourceCache3) {}
                    }
                }
                catch (Exception resourceCacheName) {
                    // empty catch block
                }
            }
        }
        if (!(returnType == null || !method.equals(HttpMethod.GET.name()) || returnType.getType().getTypeName().contains("List") || url.contains("expand") || url.contains(".well-known/okta-organization") || String.join((CharSequence)"/", uriSegments).matches("/api/v1/users/[A-Za-z0-9]+/factors/[A-Za-z0-9]+/transactions/[A-Za-z0-9]+"))) {
            Object cachedObject = cache.get(cacheKey);
            Object cacheData = null;
            if (Objects.nonNull(cachedObject) && expectedType != null && expectedType.isInstance(cachedObject)) {
                cacheData = cachedObject;
            }
            if (!Objects.isNull(cacheData)) return (T)cache.get(cacheKey);
            try (CloseableHttpResponse response = this.executeWithDPoPRetry(builder.build(), httpClientContext);){
                T t = this.processResponse(response, returnType);
                if (Objects.nonNull(t)) {
                    LinkedHashMap self;
                    Map links;
                    if (t instanceof String && accept != null && accept.contains("xml")) {
                        resourceCache3 = t;
                        return (T)resourceCache3;
                    }
                    Map map = (Map)this.getObjectMapper().convertValue(t, LinkedHashMap.class);
                    String href = null;
                    if (Objects.nonNull(map) && Objects.nonNull(links = (Map)map.get("_links")) && Objects.nonNull(self = (LinkedHashMap)links.get("self"))) {
                        href = (String)self.get("href");
                    }
                    if (Objects.nonNull(href)) {
                        cache.put(href, t);
                    } else {
                        cache.put(cacheKey, t);
                    }
                }
                T t2 = t;
                return t2;
            }
            catch (IOException | org.apache.hc.core5.http.ParseException e) {
                throw new ApiException(e);
            }
        }
        try (CloseableHttpResponse response = this.executeWithDPoPRetry(builder.build(), httpClientContext);){
            T t;
            T t3 = t = this.processResponse(response, returnType);
            return t3;
        }
        catch (IOException | org.apache.hc.core5.http.ParseException e) {
            throw new ApiException(e);
        }
    }

    private CloseableHttpResponse executeWithDPoPRetry(ClassicHttpRequest request, HttpClientContext context) throws IOException {
        try {
            return this.httpClient.execute(request, (HttpContext)context);
        }
        catch (Exception e) {
            if (this.isDPoPNonceExpired(e)) {
                this.clearAccessToken();
                return this.httpClient.execute(request, (HttpContext)context);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Request execution failed", e);
        }
    }

    private boolean isDPoPNonceExpired(Exception e) {
        if (e == null) {
            return false;
        }
        String exceptionClass = e.getClass().getName();
        if (exceptionClass.contains("DPoPNonceExpiredException")) {
            return true;
        }
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!cause.getClass().getName().contains("DPoPNonceExpiredException")) continue;
            return true;
        }
        return false;
    }

    private void clearAccessToken() {
        Authentication oauth2Auth = this.authentications.get("oauth2");
        if (oauth2Auth != null && oauth2Auth instanceof HttpBearerAuth) {
            ((HttpBearerAuth)oauth2Auth).setBearerToken((String)null);
        }
    }

    private void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams, cookieParams);
        }
    }
}

