/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.AuthenticatorEnrollment;
import com.okta.sdk.resource.model.AuthenticatorEnrollmentCreateRequest;
import com.okta.sdk.resource.model.AuthenticatorEnrollmentCreateRequestTac;
import com.okta.sdk.resource.model.TacAuthenticatorEnrollment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class UserAuthenticatorEnrollmentsApi {
    private ApiClient apiClient;

    public UserAuthenticatorEnrollmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserAuthenticatorEnrollmentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AuthenticatorEnrollment createAuthenticatorEnrollment(String userId, AuthenticatorEnrollmentCreateRequest authenticator) throws ApiException {
        return this.createAuthenticatorEnrollment(userId, authenticator, Collections.emptyMap());
    }

    public AuthenticatorEnrollment createAuthenticatorEnrollment(String userId, AuthenticatorEnrollmentCreateRequest authenticator, Map<String, String> additionalHeaders) throws ApiException {
        AuthenticatorEnrollmentCreateRequest localVarPostBody = authenticator;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling createAuthenticatorEnrollment");
        }
        if (authenticator == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticator' when calling createAuthenticatorEnrollment");
        }
        String localVarPath = "/api/v1/users/{userId}/authenticator-enrollments/phone".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorEnrollment> localVarReturnType = new TypeReference<AuthenticatorEnrollment>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TacAuthenticatorEnrollment createTacAuthenticatorEnrollment(String userId, AuthenticatorEnrollmentCreateRequestTac authenticator) throws ApiException {
        return this.createTacAuthenticatorEnrollment(userId, authenticator, Collections.emptyMap());
    }

    public TacAuthenticatorEnrollment createTacAuthenticatorEnrollment(String userId, AuthenticatorEnrollmentCreateRequestTac authenticator, Map<String, String> additionalHeaders) throws ApiException {
        AuthenticatorEnrollmentCreateRequestTac localVarPostBody = authenticator;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling createTacAuthenticatorEnrollment");
        }
        if (authenticator == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticator' when calling createTacAuthenticatorEnrollment");
        }
        String localVarPath = "/api/v1/users/{userId}/authenticator-enrollments/tac".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<TacAuthenticatorEnrollment> localVarReturnType = new TypeReference<TacAuthenticatorEnrollment>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteAuthenticatorEnrollment(String userId, String enrollmentId) throws ApiException {
        this.deleteAuthenticatorEnrollment(userId, enrollmentId, Collections.emptyMap());
    }

    public void deleteAuthenticatorEnrollment(String userId, String enrollmentId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteAuthenticatorEnrollment");
        }
        if (enrollmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'enrollmentId' when calling deleteAuthenticatorEnrollment");
        }
        String localVarPath = "/api/v1/users/{userId}/authenticator-enrollments/{enrollmentId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{enrollmentId\\}", this.apiClient.escapeString(enrollmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public AuthenticatorEnrollment getAuthenticatorEnrollment(String userId, String enrollmentId, List<String> discloseIdentifiers) throws ApiException {
        return this.getAuthenticatorEnrollment(userId, enrollmentId, discloseIdentifiers, Collections.emptyMap());
    }

    public AuthenticatorEnrollment getAuthenticatorEnrollment(String userId, String enrollmentId, List<String> discloseIdentifiers, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getAuthenticatorEnrollment");
        }
        if (enrollmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'enrollmentId' when calling getAuthenticatorEnrollment");
        }
        String localVarPath = "/api/v1/users/{userId}/authenticator-enrollments/{enrollmentId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{enrollmentId\\}", this.apiClient.escapeString(enrollmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "discloseIdentifiers", discloseIdentifiers));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorEnrollment> localVarReturnType = new TypeReference<AuthenticatorEnrollment>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthenticatorEnrollment listAuthenticatorEnrollments(String userId, List<String> discloseIdentifiers) throws ApiException {
        return this.listAuthenticatorEnrollments(userId, discloseIdentifiers, Collections.emptyMap());
    }

    public AuthenticatorEnrollment listAuthenticatorEnrollments(String userId, List<String> discloseIdentifiers, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listAuthenticatorEnrollments");
        }
        String localVarPath = "/api/v1/users/{userId}/authenticator-enrollments".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "discloseIdentifiers", discloseIdentifiers));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorEnrollment> localVarReturnType = new TypeReference<AuthenticatorEnrollment>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

