/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.ImageUploadResponse;
import com.okta.sdk.resource.model.ThemeResponse;
import com.okta.sdk.resource.model.UpdateThemeRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class ThemesApi {
    private ApiClient apiClient;

    public ThemesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ThemesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteBrandThemeBackgroundImage(String brandId, String themeId) throws ApiException {
        this.deleteBrandThemeBackgroundImage(brandId, themeId, Collections.emptyMap());
    }

    public void deleteBrandThemeBackgroundImage(String brandId, String themeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteBrandThemeBackgroundImage");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling deleteBrandThemeBackgroundImage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/background-image".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteBrandThemeFavicon(String brandId, String themeId) throws ApiException {
        this.deleteBrandThemeFavicon(brandId, themeId, Collections.emptyMap());
    }

    public void deleteBrandThemeFavicon(String brandId, String themeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteBrandThemeFavicon");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling deleteBrandThemeFavicon");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/favicon".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteBrandThemeLogo(String brandId, String themeId) throws ApiException {
        this.deleteBrandThemeLogo(brandId, themeId, Collections.emptyMap());
    }

    public void deleteBrandThemeLogo(String brandId, String themeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteBrandThemeLogo");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling deleteBrandThemeLogo");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/logo".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ThemeResponse getBrandTheme(String brandId, String themeId) throws ApiException {
        return this.getBrandTheme(brandId, themeId, Collections.emptyMap());
    }

    public ThemeResponse getBrandTheme(String brandId, String themeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getBrandTheme");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling getBrandTheme");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ThemeResponse> localVarReturnType = new TypeReference<ThemeResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ThemeResponse> listBrandThemes(String brandId) throws ApiException {
        return this.listBrandThemes(brandId, Collections.emptyMap());
    }

    public List<ThemeResponse> listBrandThemes(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling listBrandThemes");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<ThemeResponse>> localVarReturnType = new TypeReference<List<ThemeResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<ThemeResponse> listBrandThemesPaged(String brandId) {
        return this.listBrandThemesPaged(brandId, Collections.emptyMap());
    }

    public Iterable<ThemeResponse> listBrandThemesPaged(String brandId, Map<String, String> additionalHeaders) {
        return new PagedIterable<ThemeResponse>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/brands/{brandId}/themes".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<ThemeResponse>> localVarReturnType = new TypeReference<List<ThemeResponse>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<ThemeResponse>> localVarReturnType = new TypeReference<List<ThemeResponse>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public ThemeResponse replaceBrandTheme(String brandId, String themeId, UpdateThemeRequest theme) throws ApiException {
        return this.replaceBrandTheme(brandId, themeId, theme, Collections.emptyMap());
    }

    public ThemeResponse replaceBrandTheme(String brandId, String themeId, UpdateThemeRequest theme, Map<String, String> additionalHeaders) throws ApiException {
        UpdateThemeRequest localVarPostBody = theme;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceBrandTheme");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling replaceBrandTheme");
        }
        if (theme == null) {
            throw new ApiException(400, "Missing the required parameter 'theme' when calling replaceBrandTheme");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ThemeResponse> localVarReturnType = new TypeReference<ThemeResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ImageUploadResponse uploadBrandThemeBackgroundImage(String brandId, String themeId, File _file) throws ApiException {
        return this.uploadBrandThemeBackgroundImage(brandId, themeId, _file, Collections.emptyMap());
    }

    public ImageUploadResponse uploadBrandThemeBackgroundImage(String brandId, String themeId, File _file, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling uploadBrandThemeBackgroundImage");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling uploadBrandThemeBackgroundImage");
        }
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadBrandThemeBackgroundImage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/background-image".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ImageUploadResponse> localVarReturnType = new TypeReference<ImageUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ImageUploadResponse uploadBrandThemeFavicon(String brandId, String themeId, File _file) throws ApiException {
        return this.uploadBrandThemeFavicon(brandId, themeId, _file, Collections.emptyMap());
    }

    public ImageUploadResponse uploadBrandThemeFavicon(String brandId, String themeId, File _file, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling uploadBrandThemeFavicon");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling uploadBrandThemeFavicon");
        }
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadBrandThemeFavicon");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/favicon".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ImageUploadResponse> localVarReturnType = new TypeReference<ImageUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ImageUploadResponse uploadBrandThemeLogo(String brandId, String themeId, File _file) throws ApiException {
        return this.uploadBrandThemeLogo(brandId, themeId, _file, Collections.emptyMap());
    }

    public ImageUploadResponse uploadBrandThemeLogo(String brandId, String themeId, File _file, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling uploadBrandThemeLogo");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling uploadBrandThemeLogo");
        }
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadBrandThemeLogo");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/logo".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ImageUploadResponse> localVarReturnType = new TypeReference<ImageUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

