/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.ListSubscriptionsRoleRoleRefParameter;
import com.okta.sdk.resource.model.NotificationType;
import com.okta.sdk.resource.model.Subscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class SubscriptionApi {
    private ApiClient apiClient;

    public SubscriptionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Subscription getSubscriptionsNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef, NotificationType notificationType) throws ApiException {
        return this.getSubscriptionsNotificationTypeRole(roleRef, notificationType, Collections.emptyMap());
    }

    public Subscription getSubscriptionsNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef, NotificationType notificationType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (roleRef == null) {
            throw new ApiException(400, "Missing the required parameter 'roleRef' when calling getSubscriptionsNotificationTypeRole");
        }
        if (notificationType == null) {
            throw new ApiException(400, "Missing the required parameter 'notificationType' when calling getSubscriptionsNotificationTypeRole");
        }
        String localVarPath = "/api/v1/roles/{roleRef}/subscriptions/{notificationType}".replaceAll("\\{roleRef\\}", this.apiClient.escapeString(roleRef.toString())).replaceAll("\\{notificationType\\}", this.apiClient.escapeString(notificationType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Subscription> localVarReturnType = new TypeReference<Subscription>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Subscription getSubscriptionsNotificationTypeUser(NotificationType notificationType, String userId) throws ApiException {
        return this.getSubscriptionsNotificationTypeUser(notificationType, userId, Collections.emptyMap());
    }

    public Subscription getSubscriptionsNotificationTypeUser(NotificationType notificationType, String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (notificationType == null) {
            throw new ApiException(400, "Missing the required parameter 'notificationType' when calling getSubscriptionsNotificationTypeUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getSubscriptionsNotificationTypeUser");
        }
        String localVarPath = "/api/v1/users/{userId}/subscriptions/{notificationType}".replaceAll("\\{notificationType\\}", this.apiClient.escapeString(notificationType.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Subscription> localVarReturnType = new TypeReference<Subscription>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Subscription> listSubscriptionsRole(ListSubscriptionsRoleRoleRefParameter roleRef) throws ApiException {
        return this.listSubscriptionsRole(roleRef, Collections.emptyMap());
    }

    public List<Subscription> listSubscriptionsRole(ListSubscriptionsRoleRoleRefParameter roleRef, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (roleRef == null) {
            throw new ApiException(400, "Missing the required parameter 'roleRef' when calling listSubscriptionsRole");
        }
        String localVarPath = "/api/v1/roles/{roleRef}/subscriptions".replaceAll("\\{roleRef\\}", this.apiClient.escapeString(roleRef.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Subscription>> localVarReturnType = new TypeReference<List<Subscription>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<Subscription> listSubscriptionsRolePaged(ListSubscriptionsRoleRoleRefParameter roleRef) {
        return this.listSubscriptionsRolePaged(roleRef, Collections.emptyMap());
    }

    public Iterable<Subscription> listSubscriptionsRolePaged(ListSubscriptionsRoleRoleRefParameter roleRef, Map<String, String> additionalHeaders) {
        return new PagedIterable<Subscription>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/roles/{roleRef}/subscriptions".replaceAll("\\{roleRef\\}", this.apiClient.escapeString(roleRef.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<Subscription>> localVarReturnType = new TypeReference<List<Subscription>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<Subscription>> localVarReturnType = new TypeReference<List<Subscription>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public List<Subscription> listSubscriptionsUser(String userId) throws ApiException {
        return this.listSubscriptionsUser(userId, Collections.emptyMap());
    }

    public List<Subscription> listSubscriptionsUser(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSubscriptionsUser");
        }
        String localVarPath = "/api/v1/users/{userId}/subscriptions".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Subscription>> localVarReturnType = new TypeReference<List<Subscription>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<Subscription> listSubscriptionsUserPaged(String userId) {
        return this.listSubscriptionsUserPaged(userId, Collections.emptyMap());
    }

    public Iterable<Subscription> listSubscriptionsUserPaged(String userId, Map<String, String> additionalHeaders) {
        return new PagedIterable<Subscription>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/users/{userId}/subscriptions".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<Subscription>> localVarReturnType = new TypeReference<List<Subscription>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<Subscription>> localVarReturnType = new TypeReference<List<Subscription>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public void subscribeByNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef, NotificationType notificationType) throws ApiException {
        this.subscribeByNotificationTypeRole(roleRef, notificationType, Collections.emptyMap());
    }

    public void subscribeByNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef, NotificationType notificationType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (roleRef == null) {
            throw new ApiException(400, "Missing the required parameter 'roleRef' when calling subscribeByNotificationTypeRole");
        }
        if (notificationType == null) {
            throw new ApiException(400, "Missing the required parameter 'notificationType' when calling subscribeByNotificationTypeRole");
        }
        String localVarPath = "/api/v1/roles/{roleRef}/subscriptions/{notificationType}/subscribe".replaceAll("\\{roleRef\\}", this.apiClient.escapeString(roleRef.toString())).replaceAll("\\{notificationType\\}", this.apiClient.escapeString(notificationType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void subscribeByNotificationTypeUser(NotificationType notificationType, String userId) throws ApiException {
        this.subscribeByNotificationTypeUser(notificationType, userId, Collections.emptyMap());
    }

    public void subscribeByNotificationTypeUser(NotificationType notificationType, String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (notificationType == null) {
            throw new ApiException(400, "Missing the required parameter 'notificationType' when calling subscribeByNotificationTypeUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling subscribeByNotificationTypeUser");
        }
        String localVarPath = "/api/v1/users/{userId}/subscriptions/{notificationType}/subscribe".replaceAll("\\{notificationType\\}", this.apiClient.escapeString(notificationType.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unsubscribeByNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef, NotificationType notificationType) throws ApiException {
        this.unsubscribeByNotificationTypeRole(roleRef, notificationType, Collections.emptyMap());
    }

    public void unsubscribeByNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef, NotificationType notificationType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (roleRef == null) {
            throw new ApiException(400, "Missing the required parameter 'roleRef' when calling unsubscribeByNotificationTypeRole");
        }
        if (notificationType == null) {
            throw new ApiException(400, "Missing the required parameter 'notificationType' when calling unsubscribeByNotificationTypeRole");
        }
        String localVarPath = "/api/v1/roles/{roleRef}/subscriptions/{notificationType}/unsubscribe".replaceAll("\\{roleRef\\}", this.apiClient.escapeString(roleRef.toString())).replaceAll("\\{notificationType\\}", this.apiClient.escapeString(notificationType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unsubscribeByNotificationTypeUser(NotificationType notificationType, String userId) throws ApiException {
        this.unsubscribeByNotificationTypeUser(notificationType, userId, Collections.emptyMap());
    }

    public void unsubscribeByNotificationTypeUser(NotificationType notificationType, String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (notificationType == null) {
            throw new ApiException(400, "Missing the required parameter 'notificationType' when calling unsubscribeByNotificationTypeUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unsubscribeByNotificationTypeUser");
        }
        String localVarPath = "/api/v1/users/{userId}/subscriptions/{notificationType}/unsubscribe".replaceAll("\\{notificationType\\}", this.apiClient.escapeString(notificationType.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

