/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.ResourceSetBindingAddMembersRequest;
import com.okta.sdk.resource.model.ResourceSetBindingEditResponse;
import com.okta.sdk.resource.model.ResourceSetBindingMember;
import com.okta.sdk.resource.model.ResourceSetBindingMembers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RoleDResourceSetBindingMemberApi {
    private ApiClient apiClient;

    public RoleDResourceSetBindingMemberApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleDResourceSetBindingMemberApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ResourceSetBindingEditResponse addMembersToBinding(String resourceSetIdOrLabel, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance) throws ApiException {
        return this.addMembersToBinding(resourceSetIdOrLabel, roleIdOrLabel, instance, Collections.emptyMap());
    }

    public ResourceSetBindingEditResponse addMembersToBinding(String resourceSetIdOrLabel, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        ResourceSetBindingAddMembersRequest localVarPostBody = instance;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling addMembersToBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling addMembersToBinding");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling addMembersToBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindingEditResponse> localVarReturnType = new TypeReference<ResourceSetBindingEditResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSetBindingMember getMemberOfBinding(String resourceSetIdOrLabel, String roleIdOrLabel, String memberId) throws ApiException {
        return this.getMemberOfBinding(resourceSetIdOrLabel, roleIdOrLabel, memberId, Collections.emptyMap());
    }

    public ResourceSetBindingMember getMemberOfBinding(String resourceSetIdOrLabel, String roleIdOrLabel, String memberId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling getMemberOfBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling getMemberOfBinding");
        }
        if (memberId == null) {
            throw new ApiException(400, "Missing the required parameter 'memberId' when calling getMemberOfBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members/{memberId}".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString())).replaceAll("\\{memberId\\}", this.apiClient.escapeString(memberId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindingMember> localVarReturnType = new TypeReference<ResourceSetBindingMember>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSetBindingMembers listMembersOfBinding(String resourceSetIdOrLabel, String roleIdOrLabel, String after) throws ApiException {
        return this.listMembersOfBinding(resourceSetIdOrLabel, roleIdOrLabel, after, Collections.emptyMap());
    }

    public ResourceSetBindingMembers listMembersOfBinding(String resourceSetIdOrLabel, String roleIdOrLabel, String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling listMembersOfBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling listMembersOfBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindingMembers> localVarReturnType = new TypeReference<ResourceSetBindingMembers>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void unassignMemberFromBinding(String resourceSetIdOrLabel, String roleIdOrLabel, String memberId) throws ApiException {
        this.unassignMemberFromBinding(resourceSetIdOrLabel, roleIdOrLabel, memberId, Collections.emptyMap());
    }

    public void unassignMemberFromBinding(String resourceSetIdOrLabel, String roleIdOrLabel, String memberId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling unassignMemberFromBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling unassignMemberFromBinding");
        }
        if (memberId == null) {
            throw new ApiException(400, "Missing the required parameter 'memberId' when calling unassignMemberFromBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members/{memberId}".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString())).replaceAll("\\{memberId\\}", this.apiClient.escapeString(memberId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

