/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.AdminConsoleSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class OktaApplicationSettingsApi {
    private ApiClient apiClient;

    public OktaApplicationSettingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OktaApplicationSettingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AdminConsoleSettings getFirstPartyAppSettings(String appName) throws ApiException {
        return this.getFirstPartyAppSettings(appName, Collections.emptyMap());
    }

    public AdminConsoleSettings getFirstPartyAppSettings(String appName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling getFirstPartyAppSettings");
        }
        String localVarPath = "/api/v1/first-party-app-settings/{appName}".replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AdminConsoleSettings> localVarReturnType = new TypeReference<AdminConsoleSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AdminConsoleSettings replaceFirstPartyAppSettings(String appName, AdminConsoleSettings adminConsoleSettings) throws ApiException {
        return this.replaceFirstPartyAppSettings(appName, adminConsoleSettings, Collections.emptyMap());
    }

    public AdminConsoleSettings replaceFirstPartyAppSettings(String appName, AdminConsoleSettings adminConsoleSettings, Map<String, String> additionalHeaders) throws ApiException {
        AdminConsoleSettings localVarPostBody = adminConsoleSettings;
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling replaceFirstPartyAppSettings");
        }
        if (adminConsoleSettings == null) {
            throw new ApiException(400, "Missing the required parameter 'adminConsoleSettings' when calling replaceFirstPartyAppSettings");
        }
        String localVarPath = "/api/v1/first-party-app-settings/{appName}".replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AdminConsoleSettings> localVarReturnType = new TypeReference<AdminConsoleSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

