/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.CsrMetadata;
import com.okta.sdk.resource.model.IdPCsr;
import com.okta.sdk.resource.model.IdPKeyCredential;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class IdentityProviderSigningKeysApi {
    private ApiClient apiClient;

    public IdentityProviderSigningKeysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdentityProviderSigningKeysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IdPKeyCredential cloneIdentityProviderKey(String idpId, String kid, String targetIdpId) throws ApiException {
        return this.cloneIdentityProviderKey(idpId, kid, targetIdpId, Collections.emptyMap());
    }

    public IdPKeyCredential cloneIdentityProviderKey(String idpId, String kid, String targetIdpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling cloneIdentityProviderKey");
        }
        if (kid == null) {
            throw new ApiException(400, "Missing the required parameter 'kid' when calling cloneIdentityProviderKey");
        }
        if (targetIdpId == null) {
            throw new ApiException(400, "Missing the required parameter 'targetIdpId' when calling cloneIdentityProviderKey");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys/{kid}/clone".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{kid\\}", this.apiClient.escapeString(kid.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("targetIdpId", targetIdpId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdPKeyCredential> localVarReturnType = new TypeReference<IdPKeyCredential>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdPCsr generateCsrForIdentityProvider(String idpId, CsrMetadata metadata) throws ApiException {
        return this.generateCsrForIdentityProvider(idpId, metadata, Collections.emptyMap());
    }

    public IdPCsr generateCsrForIdentityProvider(String idpId, CsrMetadata metadata, Map<String, String> additionalHeaders) throws ApiException {
        CsrMetadata localVarPostBody = metadata;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling generateCsrForIdentityProvider");
        }
        if (metadata == null) {
            throw new ApiException(400, "Missing the required parameter 'metadata' when calling generateCsrForIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "application/pkcs10"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdPCsr> localVarReturnType = new TypeReference<IdPCsr>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdPKeyCredential generateIdentityProviderSigningKey(String idpId, Integer validityYears) throws ApiException {
        return this.generateIdentityProviderSigningKey(idpId, validityYears, Collections.emptyMap());
    }

    public IdPKeyCredential generateIdentityProviderSigningKey(String idpId, Integer validityYears, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling generateIdentityProviderSigningKey");
        }
        if (validityYears == null) {
            throw new ApiException(400, "Missing the required parameter 'validityYears' when calling generateIdentityProviderSigningKey");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys/generate".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("validityYears", validityYears));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdPKeyCredential> localVarReturnType = new TypeReference<IdPKeyCredential>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdPCsr getCsrForIdentityProvider(String idpId, String idpCsrId) throws ApiException {
        return this.getCsrForIdentityProvider(idpId, idpCsrId, Collections.emptyMap());
    }

    public IdPCsr getCsrForIdentityProvider(String idpId, String idpCsrId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling getCsrForIdentityProvider");
        }
        if (idpCsrId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpCsrId' when calling getCsrForIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs/{idpCsrId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{idpCsrId\\}", this.apiClient.escapeString(idpCsrId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "application/pkcs10"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdPCsr> localVarReturnType = new TypeReference<IdPCsr>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdPKeyCredential getIdentityProviderSigningKey(String idpId, String kid) throws ApiException {
        return this.getIdentityProviderSigningKey(idpId, kid, Collections.emptyMap());
    }

    public IdPKeyCredential getIdentityProviderSigningKey(String idpId, String kid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling getIdentityProviderSigningKey");
        }
        if (kid == null) {
            throw new ApiException(400, "Missing the required parameter 'kid' when calling getIdentityProviderSigningKey");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys/{kid}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{kid\\}", this.apiClient.escapeString(kid.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdPKeyCredential> localVarReturnType = new TypeReference<IdPKeyCredential>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<IdPKeyCredential> listActiveIdentityProviderSigningKey(String idpId) throws ApiException {
        return this.listActiveIdentityProviderSigningKey(idpId, Collections.emptyMap());
    }

    public List<IdPKeyCredential> listActiveIdentityProviderSigningKey(String idpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling listActiveIdentityProviderSigningKey");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys/active".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<IdPKeyCredential>> localVarReturnType = new TypeReference<List<IdPKeyCredential>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<IdPKeyCredential> listActiveIdentityProviderSigningKeyPaged(String idpId) {
        return this.listActiveIdentityProviderSigningKeyPaged(idpId, Collections.emptyMap());
    }

    public Iterable<IdPKeyCredential> listActiveIdentityProviderSigningKeyPaged(String idpId, Map<String, String> additionalHeaders) {
        return new PagedIterable<IdPKeyCredential>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/idps/{idpId}/credentials/keys/active".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<IdPKeyCredential>> localVarReturnType = new TypeReference<List<IdPKeyCredential>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<IdPKeyCredential>> localVarReturnType = new TypeReference<List<IdPKeyCredential>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public List<IdPCsr> listCsrsForIdentityProvider(String idpId) throws ApiException {
        return this.listCsrsForIdentityProvider(idpId, Collections.emptyMap());
    }

    public List<IdPCsr> listCsrsForIdentityProvider(String idpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling listCsrsForIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<IdPCsr>> localVarReturnType = new TypeReference<List<IdPCsr>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<IdPCsr> listCsrsForIdentityProviderPaged(String idpId) {
        return this.listCsrsForIdentityProviderPaged(idpId, Collections.emptyMap());
    }

    public Iterable<IdPCsr> listCsrsForIdentityProviderPaged(String idpId, Map<String, String> additionalHeaders) {
        return new PagedIterable<IdPCsr>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<IdPCsr>> localVarReturnType = new TypeReference<List<IdPCsr>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<IdPCsr>> localVarReturnType = new TypeReference<List<IdPCsr>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public List<IdPKeyCredential> listIdentityProviderSigningKeys(String idpId) throws ApiException {
        return this.listIdentityProviderSigningKeys(idpId, Collections.emptyMap());
    }

    public List<IdPKeyCredential> listIdentityProviderSigningKeys(String idpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling listIdentityProviderSigningKeys");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<IdPKeyCredential>> localVarReturnType = new TypeReference<List<IdPKeyCredential>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<IdPKeyCredential> listIdentityProviderSigningKeysPaged(String idpId) {
        return this.listIdentityProviderSigningKeysPaged(idpId, Collections.emptyMap());
    }

    public Iterable<IdPKeyCredential> listIdentityProviderSigningKeysPaged(String idpId, Map<String, String> additionalHeaders) {
        return new PagedIterable<IdPKeyCredential>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/idps/{idpId}/credentials/keys".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<IdPKeyCredential>> localVarReturnType = new TypeReference<List<IdPKeyCredential>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<IdPKeyCredential>> localVarReturnType = new TypeReference<List<IdPKeyCredential>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public IdPKeyCredential publishCsrForIdentityProvider(String idpId, String idpCsrId, File body) throws ApiException {
        return this.publishCsrForIdentityProvider(idpId, idpCsrId, body, Collections.emptyMap());
    }

    public IdPKeyCredential publishCsrForIdentityProvider(String idpId, String idpCsrId, File body, Map<String, String> additionalHeaders) throws ApiException {
        File localVarPostBody = body;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling publishCsrForIdentityProvider");
        }
        if (idpCsrId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpCsrId' when calling publishCsrForIdentityProvider");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling publishCsrForIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs/{idpCsrId}/lifecycle/publish".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{idpCsrId\\}", this.apiClient.escapeString(idpCsrId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/pkix-cert", "application/x-x509-ca-cert", "application/x-pem-file"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdPKeyCredential> localVarReturnType = new TypeReference<IdPKeyCredential>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void revokeCsrForIdentityProvider(String idpId, String idpCsrId) throws ApiException {
        this.revokeCsrForIdentityProvider(idpId, idpCsrId, Collections.emptyMap());
    }

    public void revokeCsrForIdentityProvider(String idpId, String idpCsrId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling revokeCsrForIdentityProvider");
        }
        if (idpCsrId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpCsrId' when calling revokeCsrForIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs/{idpCsrId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{idpCsrId\\}", this.apiClient.escapeString(idpCsrId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

