/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.AuthorizationServerPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class AuthorizationServerPoliciesApi {
    private ApiClient apiClient;

    public AuthorizationServerPoliciesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerPoliciesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void activateAuthorizationServerPolicy(String authServerId, String policyId) throws ApiException {
        this.activateAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    public void activateAuthorizationServerPolicy(String authServerId, String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling activateAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling activateAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/activate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public AuthorizationServerPolicy createAuthorizationServerPolicy(String authServerId, AuthorizationServerPolicy policy) throws ApiException {
        return this.createAuthorizationServerPolicy(authServerId, policy, Collections.emptyMap());
    }

    public AuthorizationServerPolicy createAuthorizationServerPolicy(String authServerId, AuthorizationServerPolicy policy, Map<String, String> additionalHeaders) throws ApiException {
        AuthorizationServerPolicy localVarPostBody = policy;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicy");
        }
        if (policy == null) {
            throw new ApiException(400, "Missing the required parameter 'policy' when calling createAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicy> localVarReturnType = new TypeReference<AuthorizationServerPolicy>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deactivateAuthorizationServerPolicy(String authServerId, String policyId) throws ApiException {
        this.deactivateAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    public void deactivateAuthorizationServerPolicy(String authServerId, String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deactivateAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/deactivate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteAuthorizationServerPolicy(String authServerId, String policyId) throws ApiException {
        this.deleteAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    public void deleteAuthorizationServerPolicy(String authServerId, String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deleteAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public AuthorizationServerPolicy getAuthorizationServerPolicy(String authServerId, String policyId) throws ApiException {
        return this.getAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    public AuthorizationServerPolicy getAuthorizationServerPolicy(String authServerId, String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicy> localVarReturnType = new TypeReference<AuthorizationServerPolicy>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuthorizationServerPolicy> listAuthorizationServerPolicies(String authServerId) throws ApiException {
        return this.listAuthorizationServerPolicies(authServerId, Collections.emptyMap());
    }

    public List<AuthorizationServerPolicy> listAuthorizationServerPolicies(String authServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicies");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthorizationServerPolicy>> localVarReturnType = new TypeReference<List<AuthorizationServerPolicy>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<AuthorizationServerPolicy> listAuthorizationServerPoliciesPaged(String authServerId) {
        return this.listAuthorizationServerPoliciesPaged(authServerId, Collections.emptyMap());
    }

    public Iterable<AuthorizationServerPolicy> listAuthorizationServerPoliciesPaged(String authServerId, Map<String, String> additionalHeaders) {
        return new PagedIterable<AuthorizationServerPolicy>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<AuthorizationServerPolicy>> localVarReturnType = new TypeReference<List<AuthorizationServerPolicy>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<AuthorizationServerPolicy>> localVarReturnType = new TypeReference<List<AuthorizationServerPolicy>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public AuthorizationServerPolicy replaceAuthorizationServerPolicy(String authServerId, String policyId, AuthorizationServerPolicy policy) throws ApiException {
        return this.replaceAuthorizationServerPolicy(authServerId, policyId, policy, Collections.emptyMap());
    }

    public AuthorizationServerPolicy replaceAuthorizationServerPolicy(String authServerId, String policyId, AuthorizationServerPolicy policy, Map<String, String> additionalHeaders) throws ApiException {
        AuthorizationServerPolicy localVarPostBody = policy;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicy");
        }
        if (policy == null) {
            throw new ApiException(400, "Missing the required parameter 'policy' when calling replaceAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicy> localVarReturnType = new TypeReference<AuthorizationServerPolicy>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

