/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.AuthenticatorBase;
import com.okta.sdk.resource.model.AuthenticatorMethodBase;
import com.okta.sdk.resource.model.AuthenticatorMethodType;
import com.okta.sdk.resource.model.AuthenticatorMethodTypeWebAuthn;
import com.okta.sdk.resource.model.CustomAAGUIDCreateRequestObject;
import com.okta.sdk.resource.model.CustomAAGUIDResponseObject;
import com.okta.sdk.resource.model.CustomAAGUIDUpdateRequestObject;
import com.okta.sdk.resource.model.WellKnownAppAuthenticatorConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class AuthenticatorApi {
    private ApiClient apiClient;

    public AuthenticatorApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthenticatorApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AuthenticatorBase activateAuthenticator(String authenticatorId) throws ApiException {
        return this.activateAuthenticator(authenticatorId, Collections.emptyMap());
    }

    public AuthenticatorBase activateAuthenticator(String authenticatorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling activateAuthenticator");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/lifecycle/activate".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorBase> localVarReturnType = new TypeReference<AuthenticatorBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthenticatorMethodBase activateAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType) throws ApiException {
        return this.activateAuthenticatorMethod(authenticatorId, methodType, Collections.emptyMap());
    }

    public AuthenticatorMethodBase activateAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling activateAuthenticatorMethod");
        }
        if (methodType == null) {
            throw new ApiException(400, "Missing the required parameter 'methodType' when calling activateAuthenticatorMethod");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}/lifecycle/activate".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{methodType\\}", this.apiClient.escapeString(methodType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthenticatorBase createAuthenticator(AuthenticatorBase authenticator, Boolean activate) throws ApiException {
        return this.createAuthenticator(authenticator, activate, Collections.emptyMap());
    }

    public AuthenticatorBase createAuthenticator(AuthenticatorBase authenticator, Boolean activate, Map<String, String> additionalHeaders) throws ApiException {
        AuthenticatorBase localVarPostBody = authenticator;
        if (authenticator == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticator' when calling createAuthenticator");
        }
        String localVarPath = "/api/v1/authenticators";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activate", activate));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorBase> localVarReturnType = new TypeReference<AuthenticatorBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomAAGUIDResponseObject createCustomAAGUID(String authenticatorId, CustomAAGUIDCreateRequestObject customAAGUIDCreateRequestObject) throws ApiException {
        return this.createCustomAAGUID(authenticatorId, customAAGUIDCreateRequestObject, Collections.emptyMap());
    }

    public CustomAAGUIDResponseObject createCustomAAGUID(String authenticatorId, CustomAAGUIDCreateRequestObject customAAGUIDCreateRequestObject, Map<String, String> additionalHeaders) throws ApiException {
        CustomAAGUIDCreateRequestObject localVarPostBody = customAAGUIDCreateRequestObject;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling createCustomAAGUID");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/aaguids".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<CustomAAGUIDResponseObject> localVarReturnType = new TypeReference<CustomAAGUIDResponseObject>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthenticatorBase deactivateAuthenticator(String authenticatorId) throws ApiException {
        return this.deactivateAuthenticator(authenticatorId, Collections.emptyMap());
    }

    public AuthenticatorBase deactivateAuthenticator(String authenticatorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling deactivateAuthenticator");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/lifecycle/deactivate".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorBase> localVarReturnType = new TypeReference<AuthenticatorBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthenticatorMethodBase deactivateAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType) throws ApiException {
        return this.deactivateAuthenticatorMethod(authenticatorId, methodType, Collections.emptyMap());
    }

    public AuthenticatorMethodBase deactivateAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling deactivateAuthenticatorMethod");
        }
        if (methodType == null) {
            throw new ApiException(400, "Missing the required parameter 'methodType' when calling deactivateAuthenticatorMethod");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}/lifecycle/deactivate".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{methodType\\}", this.apiClient.escapeString(methodType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteCustomAAGUID(String authenticatorId, String aaguid) throws ApiException {
        this.deleteCustomAAGUID(authenticatorId, aaguid, Collections.emptyMap());
    }

    public void deleteCustomAAGUID(String authenticatorId, String aaguid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling deleteCustomAAGUID");
        }
        if (aaguid == null) {
            throw new ApiException(400, "Missing the required parameter 'aaguid' when calling deleteCustomAAGUID");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/aaguids/{aaguid}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{aaguid\\}", this.apiClient.escapeString(aaguid.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public AuthenticatorBase getAuthenticator(String authenticatorId) throws ApiException {
        return this.getAuthenticator(authenticatorId, Collections.emptyMap());
    }

    public AuthenticatorBase getAuthenticator(String authenticatorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling getAuthenticator");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorBase> localVarReturnType = new TypeReference<AuthenticatorBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthenticatorMethodBase getAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType) throws ApiException {
        return this.getAuthenticatorMethod(authenticatorId, methodType, Collections.emptyMap());
    }

    public AuthenticatorMethodBase getAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling getAuthenticatorMethod");
        }
        if (methodType == null) {
            throw new ApiException(400, "Missing the required parameter 'methodType' when calling getAuthenticatorMethod");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{methodType\\}", this.apiClient.escapeString(methodType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomAAGUIDResponseObject getCustomAAGUID(String authenticatorId, String aaguid) throws ApiException {
        return this.getCustomAAGUID(authenticatorId, aaguid, Collections.emptyMap());
    }

    public CustomAAGUIDResponseObject getCustomAAGUID(String authenticatorId, String aaguid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling getCustomAAGUID");
        }
        if (aaguid == null) {
            throw new ApiException(400, "Missing the required parameter 'aaguid' when calling getCustomAAGUID");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/aaguids/{aaguid}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{aaguid\\}", this.apiClient.escapeString(aaguid.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<CustomAAGUIDResponseObject> localVarReturnType = new TypeReference<CustomAAGUIDResponseObject>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<WellKnownAppAuthenticatorConfiguration> getWellKnownAppAuthenticatorConfiguration(String oauthClientId) throws ApiException {
        return this.getWellKnownAppAuthenticatorConfiguration(oauthClientId, Collections.emptyMap());
    }

    public List<WellKnownAppAuthenticatorConfiguration> getWellKnownAppAuthenticatorConfiguration(String oauthClientId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (oauthClientId == null) {
            throw new ApiException(400, "Missing the required parameter 'oauthClientId' when calling getWellKnownAppAuthenticatorConfiguration");
        }
        String localVarPath = "/.well-known/app-authenticator-configuration";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("oauthClientId", oauthClientId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<List<WellKnownAppAuthenticatorConfiguration>> localVarReturnType = new TypeReference<List<WellKnownAppAuthenticatorConfiguration>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<WellKnownAppAuthenticatorConfiguration> getWellKnownAppAuthenticatorConfigurationPaged(String oauthClientId) {
        return this.getWellKnownAppAuthenticatorConfigurationPaged(oauthClientId, Collections.emptyMap());
    }

    public Iterable<WellKnownAppAuthenticatorConfiguration> getWellKnownAppAuthenticatorConfigurationPaged(String oauthClientId, Map<String, String> additionalHeaders) {
        return new PagedIterable<WellKnownAppAuthenticatorConfiguration>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/.well-known/app-authenticator-configuration";
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("oauthClientId", oauthClientId));
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{};
                    TypeReference<List<WellKnownAppAuthenticatorConfiguration>> localVarReturnType = new TypeReference<List<WellKnownAppAuthenticatorConfiguration>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{};
                TypeReference<List<WellKnownAppAuthenticatorConfiguration>> localVarReturnType = new TypeReference<List<WellKnownAppAuthenticatorConfiguration>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public List<CustomAAGUIDResponseObject> listAllCustomAAGUIDs(String authenticatorId) throws ApiException {
        return this.listAllCustomAAGUIDs(authenticatorId, Collections.emptyMap());
    }

    public List<CustomAAGUIDResponseObject> listAllCustomAAGUIDs(String authenticatorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling listAllCustomAAGUIDs");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/aaguids".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<CustomAAGUIDResponseObject>> localVarReturnType = new TypeReference<List<CustomAAGUIDResponseObject>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<CustomAAGUIDResponseObject> listAllCustomAAGUIDsPaged(String authenticatorId) {
        return this.listAllCustomAAGUIDsPaged(authenticatorId, Collections.emptyMap());
    }

    public Iterable<CustomAAGUIDResponseObject> listAllCustomAAGUIDsPaged(String authenticatorId, Map<String, String> additionalHeaders) {
        return new PagedIterable<CustomAAGUIDResponseObject>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/authenticators/{authenticatorId}/aaguids".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<CustomAAGUIDResponseObject>> localVarReturnType = new TypeReference<List<CustomAAGUIDResponseObject>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<CustomAAGUIDResponseObject>> localVarReturnType = new TypeReference<List<CustomAAGUIDResponseObject>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public List<AuthenticatorMethodBase> listAuthenticatorMethods(String authenticatorId) throws ApiException {
        return this.listAuthenticatorMethods(authenticatorId, Collections.emptyMap());
    }

    public List<AuthenticatorMethodBase> listAuthenticatorMethods(String authenticatorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling listAuthenticatorMethods");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthenticatorMethodBase>> localVarReturnType = new TypeReference<List<AuthenticatorMethodBase>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<AuthenticatorMethodBase> listAuthenticatorMethodsPaged(String authenticatorId) {
        return this.listAuthenticatorMethodsPaged(authenticatorId, Collections.emptyMap());
    }

    public Iterable<AuthenticatorMethodBase> listAuthenticatorMethodsPaged(String authenticatorId, Map<String, String> additionalHeaders) {
        return new PagedIterable<AuthenticatorMethodBase>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<AuthenticatorMethodBase>> localVarReturnType = new TypeReference<List<AuthenticatorMethodBase>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<AuthenticatorMethodBase>> localVarReturnType = new TypeReference<List<AuthenticatorMethodBase>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public List<AuthenticatorBase> listAuthenticators() throws ApiException {
        return this.listAuthenticators(Collections.emptyMap());
    }

    public List<AuthenticatorBase> listAuthenticators(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/authenticators";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthenticatorBase>> localVarReturnType = new TypeReference<List<AuthenticatorBase>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<AuthenticatorBase> listAuthenticatorsPaged() {
        return this.listAuthenticatorsPaged(Collections.emptyMap());
    }

    public Iterable<AuthenticatorBase> listAuthenticatorsPaged(Map<String, String> additionalHeaders) {
        return new PagedIterable<AuthenticatorBase>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/authenticators";
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<AuthenticatorBase>> localVarReturnType = new TypeReference<List<AuthenticatorBase>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<AuthenticatorBase>> localVarReturnType = new TypeReference<List<AuthenticatorBase>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public AuthenticatorBase replaceAuthenticator(String authenticatorId, AuthenticatorBase authenticator) throws ApiException {
        return this.replaceAuthenticator(authenticatorId, authenticator, Collections.emptyMap());
    }

    public AuthenticatorBase replaceAuthenticator(String authenticatorId, AuthenticatorBase authenticator, Map<String, String> additionalHeaders) throws ApiException {
        AuthenticatorBase localVarPostBody = authenticator;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling replaceAuthenticator");
        }
        if (authenticator == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticator' when calling replaceAuthenticator");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorBase> localVarReturnType = new TypeReference<AuthenticatorBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthenticatorMethodBase replaceAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType, AuthenticatorMethodBase authenticatorMethodBase) throws ApiException {
        return this.replaceAuthenticatorMethod(authenticatorId, methodType, authenticatorMethodBase, Collections.emptyMap());
    }

    public AuthenticatorMethodBase replaceAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType, AuthenticatorMethodBase authenticatorMethodBase, Map<String, String> additionalHeaders) throws ApiException {
        AuthenticatorMethodBase localVarPostBody = authenticatorMethodBase;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling replaceAuthenticatorMethod");
        }
        if (methodType == null) {
            throw new ApiException(400, "Missing the required parameter 'methodType' when calling replaceAuthenticatorMethod");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{methodType\\}", this.apiClient.escapeString(methodType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomAAGUIDResponseObject replaceCustomAAGUID(String authenticatorId, String aaguid, CustomAAGUIDUpdateRequestObject customAAGUIDUpdateRequestObject) throws ApiException {
        return this.replaceCustomAAGUID(authenticatorId, aaguid, customAAGUIDUpdateRequestObject, Collections.emptyMap());
    }

    public CustomAAGUIDResponseObject replaceCustomAAGUID(String authenticatorId, String aaguid, CustomAAGUIDUpdateRequestObject customAAGUIDUpdateRequestObject, Map<String, String> additionalHeaders) throws ApiException {
        CustomAAGUIDUpdateRequestObject localVarPostBody = customAAGUIDUpdateRequestObject;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling replaceCustomAAGUID");
        }
        if (aaguid == null) {
            throw new ApiException(400, "Missing the required parameter 'aaguid' when calling replaceCustomAAGUID");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/aaguids/{aaguid}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{aaguid\\}", this.apiClient.escapeString(aaguid.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<CustomAAGUIDResponseObject> localVarReturnType = new TypeReference<CustomAAGUIDResponseObject>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomAAGUIDResponseObject updateCustomAAGUID(String authenticatorId, String aaguid, CustomAAGUIDUpdateRequestObject customAAGUIDUpdateRequestObject) throws ApiException {
        return this.updateCustomAAGUID(authenticatorId, aaguid, customAAGUIDUpdateRequestObject, Collections.emptyMap());
    }

    public CustomAAGUIDResponseObject updateCustomAAGUID(String authenticatorId, String aaguid, CustomAAGUIDUpdateRequestObject customAAGUIDUpdateRequestObject, Map<String, String> additionalHeaders) throws ApiException {
        CustomAAGUIDUpdateRequestObject localVarPostBody = customAAGUIDUpdateRequestObject;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling updateCustomAAGUID");
        }
        if (aaguid == null) {
            throw new ApiException(400, "Missing the required parameter 'aaguid' when calling updateCustomAAGUID");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/aaguids/{aaguid}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{aaguid\\}", this.apiClient.escapeString(aaguid.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<CustomAAGUIDResponseObject> localVarReturnType = new TypeReference<CustomAAGUIDResponseObject>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void verifyRpIdDomain(String authenticatorId, AuthenticatorMethodTypeWebAuthn webAuthnMethodType) throws ApiException {
        this.verifyRpIdDomain(authenticatorId, webAuthnMethodType, Collections.emptyMap());
    }

    public void verifyRpIdDomain(String authenticatorId, AuthenticatorMethodTypeWebAuthn webAuthnMethodType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling verifyRpIdDomain");
        }
        if (webAuthnMethodType == null) {
            throw new ApiException(400, "Missing the required parameter 'webAuthnMethodType' when calling verifyRpIdDomain");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{webAuthnMethodType}/verify-rp-id-domain".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{webAuthnMethodType\\}", this.apiClient.escapeString(webAuthnMethodType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

