/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.OrgCrossAppAccessConnection;
import com.okta.sdk.resource.model.OrgCrossAppAccessConnectionPatchRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class ApplicationCrossAppAccessConnectionsApi {
    private ApiClient apiClient;

    public ApplicationCrossAppAccessConnectionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationCrossAppAccessConnectionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OrgCrossAppAccessConnection createCrossAppAccessConnection(String appId, OrgCrossAppAccessConnection orgCrossAppAccessConnection) throws ApiException {
        return this.createCrossAppAccessConnection(appId, orgCrossAppAccessConnection, Collections.emptyMap());
    }

    public OrgCrossAppAccessConnection createCrossAppAccessConnection(String appId, OrgCrossAppAccessConnection orgCrossAppAccessConnection, Map<String, String> additionalHeaders) throws ApiException {
        OrgCrossAppAccessConnection localVarPostBody = orgCrossAppAccessConnection;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createCrossAppAccessConnection");
        }
        if (orgCrossAppAccessConnection == null) {
            throw new ApiException(400, "Missing the required parameter 'orgCrossAppAccessConnection' when calling createCrossAppAccessConnection");
        }
        String localVarPath = "/api/v1/apps/{appId}/cwo/connections".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OrgCrossAppAccessConnection> localVarReturnType = new TypeReference<OrgCrossAppAccessConnection>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteCrossAppAccessConnection(String appId, String connectionId) throws ApiException {
        this.deleteCrossAppAccessConnection(appId, connectionId, Collections.emptyMap());
    }

    public void deleteCrossAppAccessConnection(String appId, String connectionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteCrossAppAccessConnection");
        }
        if (connectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionId' when calling deleteCrossAppAccessConnection");
        }
        String localVarPath = "/api/v1/apps/{appId}/cwo/connections/{connectionId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{connectionId\\}", this.apiClient.escapeString(connectionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<OrgCrossAppAccessConnection> getAllCrossAppAccessConnections(String appId, String after, Integer limit) throws ApiException {
        return this.getAllCrossAppAccessConnections(appId, after, limit, Collections.emptyMap());
    }

    public List<OrgCrossAppAccessConnection> getAllCrossAppAccessConnections(String appId, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getAllCrossAppAccessConnections");
        }
        String localVarPath = "/api/v1/apps/{appId}/cwo/connections".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<OrgCrossAppAccessConnection>> localVarReturnType = new TypeReference<List<OrgCrossAppAccessConnection>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<OrgCrossAppAccessConnection> getAllCrossAppAccessConnectionsPaged(String appId, String after, Integer limit) {
        return this.getAllCrossAppAccessConnectionsPaged(appId, after, limit, Collections.emptyMap());
    }

    public Iterable<OrgCrossAppAccessConnection> getAllCrossAppAccessConnectionsPaged(String appId, String after, Integer limit, Map<String, String> additionalHeaders) {
        return new PagedIterable<OrgCrossAppAccessConnection>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/apps/{appId}/cwo/connections".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<OrgCrossAppAccessConnection>> localVarReturnType = new TypeReference<List<OrgCrossAppAccessConnection>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<OrgCrossAppAccessConnection>> localVarReturnType = new TypeReference<List<OrgCrossAppAccessConnection>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public OrgCrossAppAccessConnection getCrossAppAccessConnection(String appId, String connectionId) throws ApiException {
        return this.getCrossAppAccessConnection(appId, connectionId, Collections.emptyMap());
    }

    public OrgCrossAppAccessConnection getCrossAppAccessConnection(String appId, String connectionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getCrossAppAccessConnection");
        }
        if (connectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionId' when calling getCrossAppAccessConnection");
        }
        String localVarPath = "/api/v1/apps/{appId}/cwo/connections/{connectionId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{connectionId\\}", this.apiClient.escapeString(connectionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OrgCrossAppAccessConnection> localVarReturnType = new TypeReference<OrgCrossAppAccessConnection>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OrgCrossAppAccessConnection updateCrossAppAccessConnection(String appId, String connectionId, OrgCrossAppAccessConnectionPatchRequest orgCrossAppAccessConnectionPatchRequest) throws ApiException {
        return this.updateCrossAppAccessConnection(appId, connectionId, orgCrossAppAccessConnectionPatchRequest, Collections.emptyMap());
    }

    public OrgCrossAppAccessConnection updateCrossAppAccessConnection(String appId, String connectionId, OrgCrossAppAccessConnectionPatchRequest orgCrossAppAccessConnectionPatchRequest, Map<String, String> additionalHeaders) throws ApiException {
        OrgCrossAppAccessConnectionPatchRequest localVarPostBody = orgCrossAppAccessConnectionPatchRequest;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateCrossAppAccessConnection");
        }
        if (connectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionId' when calling updateCrossAppAccessConnection");
        }
        if (orgCrossAppAccessConnectionPatchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'orgCrossAppAccessConnectionPatchRequest' when calling updateCrossAppAccessConnection");
        }
        String localVarPath = "/api/v1/apps/{appId}/cwo/connections/{connectionId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{connectionId\\}", this.apiClient.escapeString(connectionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OrgCrossAppAccessConnection> localVarReturnType = new TypeReference<OrgCrossAppAccessConnection>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

