/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.helper;

import com.okta.commons.lang.Assert;
import com.okta.sdk.resource.client.ApiClient;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginationUtil {
    private static final Logger log = LoggerFactory.getLogger(PaginationUtil.class);

    @Deprecated(forRemoval=true, since="24.1.0")
    public static String getAfter(ApiClient apiClient) {
        return PaginationUtil.getAfter(PaginationUtil.getNextPage(apiClient));
    }

    private static String getAfter(String nextPage) {
        try {
            URL url = new URL(nextPage);
            String after = PaginationUtil.splitQuery(url).get("after");
            log.debug("after: {}", (Object)after);
            return after;
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            return null;
        }
    }

    private static String getNextPage(ApiClient apiClient) {
        Assert.notNull((Object)apiClient, (String)"apiClient cannot be null");
        Assert.notNull(apiClient.getResponseHeaders(), (String)"apiClient is missing response headers");
        Assert.notNull(apiClient.getResponseHeaders().get("link"), (String)"apiClient is missing 'link' response headers");
        List<String> linkHeaders = apiClient.getResponseHeaders().get("link");
        String nextPage = null;
        for (String linkHeader : linkHeaders) {
            String[] parts = linkHeader.split("; *");
            String url = parts[0].replaceAll("<", "").replaceAll(">", "");
            String rel = parts[1];
            if (!rel.equals("rel=\"next\"")) continue;
            nextPage = url;
        }
        log.debug("Next Page: {}", nextPage);
        return nextPage;
    }

    private static Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        Assert.notNull((Object)url, (String)"url cannot be null");
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        String query = url.getQuery();
        for (String pair : pairs = query.split("&")) {
            int index = pair.indexOf("=");
            query_pairs.put(URLDecoder.decode(pair.substring(0, index), StandardCharsets.UTF_8.name()), URLDecoder.decode(pair.substring(index + 1), StandardCharsets.UTF_8.name()));
        }
        return query_pairs;
    }
}

