/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"attributeStatements", "audienceRestriction", "authnContextClassRef", "groupFilter", "groupName", "groupValueFormat", "nameIDFormat", "realm", "siteURL", "usernameAttribute", "wReplyOverride", "wReplyURL"})
public class WsFederationApplicationSettingsApplication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ATTRIBUTE_STATEMENTS = "attributeStatements";
    private String attributeStatements;
    public static final String JSON_PROPERTY_AUDIENCE_RESTRICTION = "audienceRestriction";
    private String audienceRestriction;
    public static final String JSON_PROPERTY_AUTHN_CONTEXT_CLASS_REF = "authnContextClassRef";
    private String authnContextClassRef;
    public static final String JSON_PROPERTY_GROUP_FILTER = "groupFilter";
    private String groupFilter;
    public static final String JSON_PROPERTY_GROUP_NAME = "groupName";
    private String groupName;
    public static final String JSON_PROPERTY_GROUP_VALUE_FORMAT = "groupValueFormat";
    private GroupValueFormatEnum groupValueFormat;
    public static final String JSON_PROPERTY_NAME_I_D_FORMAT = "nameIDFormat";
    private String nameIDFormat;
    public static final String JSON_PROPERTY_REALM = "realm";
    private String realm;
    public static final String JSON_PROPERTY_SITE_U_R_L = "siteURL";
    private String siteURL;
    public static final String JSON_PROPERTY_USERNAME_ATTRIBUTE = "usernameAttribute";
    private UsernameAttributeEnum usernameAttribute;
    public static final String JSON_PROPERTY_W_REPLY_OVERRIDE = "wReplyOverride";
    private Boolean wReplyOverride;
    public static final String JSON_PROPERTY_W_REPLY_U_R_L = "wReplyURL";
    private String wReplyURL;

    public WsFederationApplicationSettingsApplication attributeStatements(String attributeStatements) {
        this.attributeStatements = attributeStatements;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="You can federate user attributes such as Okta profile fields, LDAP, Active Directory, and Workday values. The SP uses the federated WS-Fed attribute values accordingly.")
    @JsonProperty(value="attributeStatements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAttributeStatements() {
        return this.attributeStatements;
    }

    @JsonProperty(value="attributeStatements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributeStatements(String attributeStatements) {
        this.attributeStatements = attributeStatements;
    }

    public WsFederationApplicationSettingsApplication audienceRestriction(String audienceRestriction) {
        this.audienceRestriction = audienceRestriction;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The entity ID of the SP. Use the entity ID value exactly as provided by the SP.")
    @JsonProperty(value="audienceRestriction")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAudienceRestriction() {
        return this.audienceRestriction;
    }

    @JsonProperty(value="audienceRestriction")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAudienceRestriction(String audienceRestriction) {
        this.audienceRestriction = audienceRestriction;
    }

    public WsFederationApplicationSettingsApplication authnContextClassRef(String authnContextClassRef) {
        this.authnContextClassRef = authnContextClassRef;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifies the SAML authentication context class for the assertion's authentication statement")
    @JsonProperty(value="authnContextClassRef")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    @JsonProperty(value="authnContextClassRef")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthnContextClassRef(String authnContextClassRef) {
        this.authnContextClassRef = authnContextClassRef;
    }

    public WsFederationApplicationSettingsApplication groupFilter(String groupFilter) {
        this.groupFilter = groupFilter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A regular expression that filters for the User Groups you want included with the `groupName` attribute. If the matching User Group has a corresponding AD group, then the attribute statement includes the value of the attribute specified by `groupValueFormat`. If the matching User Group doesn't contain a corresponding AD group, then the `groupName` is used in the attribute statement.")
    @JsonProperty(value="groupFilter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupFilter() {
        return this.groupFilter;
    }

    @JsonProperty(value="groupFilter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupFilter(String groupFilter) {
        this.groupFilter = groupFilter;
    }

    public WsFederationApplicationSettingsApplication groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The group name to include in the WS-Fed response attribute statement. This property is used in conjunction with the `groupFilter` property.  Groups that are filtered through the `groupFilter` expression are included with the `groupName` in the attribute statement. Any users that belong to the group you've filtered are included in the WS-Fed response attribute statement.")
    @JsonProperty(value="groupName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupName() {
        return this.groupName;
    }

    @JsonProperty(value="groupName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public WsFederationApplicationSettingsApplication groupValueFormat(GroupValueFormatEnum groupValueFormat) {
        this.groupValueFormat = groupValueFormat;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Specifies the WS-Fed assertion attribute value for filtered groups. This attribute is only applied to Active Directory groups.")
    @JsonProperty(value="groupValueFormat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GroupValueFormatEnum getGroupValueFormat() {
        return this.groupValueFormat;
    }

    @JsonProperty(value="groupValueFormat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGroupValueFormat(GroupValueFormatEnum groupValueFormat) {
        this.groupValueFormat = groupValueFormat;
    }

    public WsFederationApplicationSettingsApplication nameIDFormat(String nameIDFormat) {
        this.nameIDFormat = nameIDFormat;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The username format that you send in the WS-Fed response")
    @JsonProperty(value="nameIDFormat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameIDFormat() {
        return this.nameIDFormat;
    }

    @JsonProperty(value="nameIDFormat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameIDFormat(String nameIDFormat) {
        this.nameIDFormat = nameIDFormat;
    }

    public WsFederationApplicationSettingsApplication realm(String realm) {
        this.realm = realm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The uniform resource identifier (URI) of the WS-Fed app that's used to share resources securely within a domain. It's the identity that's sent to the Okta IdP when signing in. See [Realm name](https://help.okta.com/okta_help.htm?type=oie&id=ext_Apps_Configure_Okta_Template_WS_Federation#Realm).")
    @JsonProperty(value="realm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRealm() {
        return this.realm;
    }

    @JsonProperty(value="realm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRealm(String realm) {
        this.realm = realm;
    }

    public WsFederationApplicationSettingsApplication siteURL(String siteURL) {
        this.siteURL = siteURL;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Launch URL for the web app")
    @JsonProperty(value="siteURL")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSiteURL() {
        return this.siteURL;
    }

    @JsonProperty(value="siteURL")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSiteURL(String siteURL) {
        this.siteURL = siteURL;
    }

    public WsFederationApplicationSettingsApplication usernameAttribute(UsernameAttributeEnum usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Specifies additional username attribute statements to include in the WS-Fed assertion")
    @JsonProperty(value="usernameAttribute")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UsernameAttributeEnum getUsernameAttribute() {
        return this.usernameAttribute;
    }

    @JsonProperty(value="usernameAttribute")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUsernameAttribute(UsernameAttributeEnum usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public WsFederationApplicationSettingsApplication wReplyOverride(Boolean wReplyOverride) {
        this.wReplyOverride = wReplyOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Enables a web app to override the `wReplyURL` URL with a reply parameter.")
    @JsonProperty(value="wReplyOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getwReplyOverride() {
        return this.wReplyOverride;
    }

    @JsonProperty(value="wReplyOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setwReplyOverride(Boolean wReplyOverride) {
        this.wReplyOverride = wReplyOverride;
    }

    public WsFederationApplicationSettingsApplication wReplyURL(String wReplyURL) {
        this.wReplyURL = wReplyURL;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="http://test.acme.com/example-post-sign/", required=true, value="The WS-Fed SP endpoint where your users sign in")
    @JsonProperty(value="wReplyURL")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getwReplyURL() {
        return this.wReplyURL;
    }

    @JsonProperty(value="wReplyURL")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setwReplyURL(String wReplyURL) {
        this.wReplyURL = wReplyURL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WsFederationApplicationSettingsApplication wsFederationApplicationSettingsApplication = (WsFederationApplicationSettingsApplication)o;
        return Objects.equals(this.attributeStatements, wsFederationApplicationSettingsApplication.attributeStatements) && Objects.equals(this.audienceRestriction, wsFederationApplicationSettingsApplication.audienceRestriction) && Objects.equals(this.authnContextClassRef, wsFederationApplicationSettingsApplication.authnContextClassRef) && Objects.equals(this.groupFilter, wsFederationApplicationSettingsApplication.groupFilter) && Objects.equals(this.groupName, wsFederationApplicationSettingsApplication.groupName) && Objects.equals((Object)this.groupValueFormat, (Object)wsFederationApplicationSettingsApplication.groupValueFormat) && Objects.equals(this.nameIDFormat, wsFederationApplicationSettingsApplication.nameIDFormat) && Objects.equals(this.realm, wsFederationApplicationSettingsApplication.realm) && Objects.equals(this.siteURL, wsFederationApplicationSettingsApplication.siteURL) && Objects.equals((Object)this.usernameAttribute, (Object)wsFederationApplicationSettingsApplication.usernameAttribute) && Objects.equals(this.wReplyOverride, wsFederationApplicationSettingsApplication.wReplyOverride) && Objects.equals(this.wReplyURL, wsFederationApplicationSettingsApplication.wReplyURL);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributeStatements, this.audienceRestriction, this.authnContextClassRef, this.groupFilter, this.groupName, this.groupValueFormat, this.nameIDFormat, this.realm, this.siteURL, this.usernameAttribute, this.wReplyOverride, this.wReplyURL});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WsFederationApplicationSettingsApplication {\n");
        sb.append("    attributeStatements: ").append(this.toIndentedString(this.attributeStatements)).append("\n");
        sb.append("    audienceRestriction: ").append(this.toIndentedString(this.audienceRestriction)).append("\n");
        sb.append("    authnContextClassRef: ").append(this.toIndentedString(this.authnContextClassRef)).append("\n");
        sb.append("    groupFilter: ").append(this.toIndentedString(this.groupFilter)).append("\n");
        sb.append("    groupName: ").append(this.toIndentedString(this.groupName)).append("\n");
        sb.append("    groupValueFormat: ").append(this.toIndentedString((Object)this.groupValueFormat)).append("\n");
        sb.append("    nameIDFormat: ").append(this.toIndentedString(this.nameIDFormat)).append("\n");
        sb.append("    realm: ").append(this.toIndentedString(this.realm)).append("\n");
        sb.append("    siteURL: ").append(this.toIndentedString(this.siteURL)).append("\n");
        sb.append("    usernameAttribute: ").append(this.toIndentedString((Object)this.usernameAttribute)).append("\n");
        sb.append("    wReplyOverride: ").append(this.toIndentedString(this.wReplyOverride)).append("\n");
        sb.append("    wReplyURL: ").append(this.toIndentedString(this.wReplyURL)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GroupValueFormatEnum {
        WINDOWS_DOMAIN_QUALIFIED_NAME(String.valueOf("windowsDomainQualifiedName")),
        SAM_ACCOUNT_NAME(String.valueOf("samAccountName")),
        DN(String.valueOf("dn")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private GroupValueFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GroupValueFormatEnum fromValue(String value) {
            for (GroupValueFormatEnum b : GroupValueFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum UsernameAttributeEnum {
        USERNAME(String.valueOf("username")),
        UPN(String.valueOf("upn")),
        UPN_AND_USERNAME(String.valueOf("upnAndUsername")),
        NONE(String.valueOf("none")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private UsernameAttributeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UsernameAttributeEnum fromValue(String value) {
            for (UsernameAttributeEnum b : UsernameAttributeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

