/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Credential request object for the initialized credential, along with the enrollment and key identifiers to associate with the credential")
@JsonPropertyOrder(value={"authenticatorEnrollmentId", "credRequestJwe", "keyId"})
public class WebAuthnCredRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID = "authenticatorEnrollmentId";
    private String authenticatorEnrollmentId;
    public static final String JSON_PROPERTY_CRED_REQUEST_JWE = "credRequestJwe";
    private String credRequestJwe;
    public static final String JSON_PROPERTY_KEY_ID = "keyId";
    private String keyId;

    public WebAuthnCredRequest authenticatorEnrollmentId(String authenticatorEnrollmentId) {
        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID for a WebAuthn preregistration factor in Okta")
    @JsonProperty(value="authenticatorEnrollmentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthenticatorEnrollmentId() {
        return this.authenticatorEnrollmentId;
    }

    @JsonProperty(value="authenticatorEnrollmentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorEnrollmentId(String authenticatorEnrollmentId) {
        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
    }

    public WebAuthnCredRequest credRequestJwe(String credRequestJwe) {
        this.credRequestJwe = credRequestJwe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Encrypted JWE of credential request for the fulfillment provider")
    @JsonProperty(value="credRequestJwe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCredRequestJwe() {
        return this.credRequestJwe;
    }

    @JsonProperty(value="credRequestJwe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredRequestJwe(String credRequestJwe) {
        this.credRequestJwe = credRequestJwe;
    }

    public WebAuthnCredRequest keyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID for the Okta response key-pair used to encrypt and decrypt credential requests and responses")
    @JsonProperty(value="keyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKeyId() {
        return this.keyId;
    }

    @JsonProperty(value="keyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthnCredRequest webAuthnCredRequest = (WebAuthnCredRequest)o;
        return Objects.equals(this.authenticatorEnrollmentId, webAuthnCredRequest.authenticatorEnrollmentId) && Objects.equals(this.credRequestJwe, webAuthnCredRequest.credRequestJwe) && Objects.equals(this.keyId, webAuthnCredRequest.keyId);
    }

    public int hashCode() {
        return Objects.hash(this.authenticatorEnrollmentId, this.credRequestJwe, this.keyId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebAuthnCredRequest {\n");
        sb.append("    authenticatorEnrollmentId: ").append(this.toIndentedString(this.authenticatorEnrollmentId)).append("\n");
        sb.append("    credRequestJwe: ").append(this.toIndentedString(this.credRequestJwe)).append("\n");
        sb.append("    keyId: ").append(this.toIndentedString(this.keyId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

