/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.UserFactorLinks;
import com.okta.sdk.resource.model.UserFactorVerifyResult;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"expiresAt", "factorMessage", "factorResult", "profile", "_embedded", "_links"})
public class UserFactorVerifyResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_FACTOR_MESSAGE = "factorMessage";
    private JsonNullable<String> factorMessage = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FACTOR_RESULT = "factorResult";
    private UserFactorVerifyResult factorResult;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;
    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserFactorLinks links;

    @Nullable
    @ApiModelProperty(example="2022-08-25T00:31Z", value="Timestamp when the verification expires")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @Nullable
    @ApiModelProperty(value="Optional display message for factor verification")
    @JsonIgnore
    public String getFactorMessage() {
        if (this.factorMessage == null) {
            this.factorMessage = JsonNullable.undefined();
        }
        return (String)this.factorMessage.orElse(null);
    }

    @JsonProperty(value="factorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFactorMessage_JsonNullable() {
        return this.factorMessage;
    }

    @JsonProperty(value="factorMessage")
    private void setFactorMessage_JsonNullable(JsonNullable<String> factorMessage) {
        this.factorMessage = factorMessage;
    }

    public UserFactorVerifyResponse factorResult(UserFactorVerifyResult factorResult) {
        this.factorResult = factorResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="factorResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorVerifyResult getFactorResult() {
        return this.factorResult;
    }

    @JsonProperty(value="factorResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFactorResult(UserFactorVerifyResult factorResult) {
        this.factorResult = factorResult;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getProfile() {
        return this.profile;
    }

    public UserFactorVerifyResponse embedded(Map<String, Object> embedded) {
        this.embedded = embedded;
        return this;
    }

    public UserFactorVerifyResponse putembeddedItem(String key, Object embeddedItem) {
        if (this.embedded == null) {
            this.embedded = new HashMap<String, Object>();
        }
        this.embedded.put(key, embeddedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_embedded")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getEmbedded() {
        return this.embedded;
    }

    @JsonProperty(value="_embedded")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmbedded(Map<String, Object> embedded) {
        this.embedded = embedded;
    }

    public UserFactorVerifyResponse links(UserFactorLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserFactorLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFactorVerifyResponse userFactorVerifyResponse = (UserFactorVerifyResponse)o;
        return Objects.equals(this.expiresAt, userFactorVerifyResponse.expiresAt) && UserFactorVerifyResponse.equalsNullable(this.factorMessage, userFactorVerifyResponse.factorMessage) && Objects.equals((Object)this.factorResult, (Object)userFactorVerifyResponse.factorResult) && Objects.equals(this.profile, userFactorVerifyResponse.profile) && Objects.equals(this.embedded, userFactorVerifyResponse.embedded) && Objects.equals(this.links, userFactorVerifyResponse.links);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expiresAt, UserFactorVerifyResponse.hashCodeNullable(this.factorMessage), this.factorResult, this.profile, this.embedded, this.links});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorVerifyResponse {\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    factorMessage: ").append(this.toIndentedString(this.factorMessage)).append("\n");
        sb.append("    factorResult: ").append(this.toIndentedString((Object)this.factorResult)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    embedded: ").append(this.toIndentedString(this.embedded)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

