/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.UserFactorActivatePushResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Activation requests have a short lifetime and expire if the activation isn't completed before the indicated timestamp. If the activation expires, use the returned `activate` link to restart the process.")
@JsonPropertyOrder(value={"expiresAt", "factorResult"})
public class UserFactorActivatePush
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_FACTOR_RESULT = "factorResult";
    private UserFactorActivatePushResult factorResult;

    @Nullable
    @ApiModelProperty(example="2022-08-25T00:31Z", value="Timestamp when the factor verification attempt expires")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public UserFactorActivatePush factorResult(UserFactorActivatePushResult factorResult) {
        this.factorResult = factorResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="factorResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorActivatePushResult getFactorResult() {
        return this.factorResult;
    }

    @JsonProperty(value="factorResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFactorResult(UserFactorActivatePushResult factorResult) {
        this.factorResult = factorResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFactorActivatePush userFactorActivatePush = (UserFactorActivatePush)o;
        return Objects.equals(this.expiresAt, userFactorActivatePush.expiresAt) && Objects.equals((Object)this.factorResult, (Object)userFactorActivatePush.factorResult);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expiresAt, this.factorResult});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorActivatePush {\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    factorResult: ").append(this.toIndentedString((Object)this.factorResult)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

