/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="SAML test details")
@JsonPropertyOrder(value={"idp", "sp", "jit", "spInitiateUrl", "spInitiateDescription"})
@JsonTypeName(value="TestInfo_samlTestConfiguration")
public class TestInfoSamlTestConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_IDP = "idp";
    private Boolean idp;
    public static final String JSON_PROPERTY_SP = "sp";
    private Boolean sp;
    public static final String JSON_PROPERTY_JIT = "jit";
    private Boolean jit;
    public static final String JSON_PROPERTY_SP_INITIATE_URL = "spInitiateUrl";
    private URI spInitiateUrl;
    public static final String JSON_PROPERTY_SP_INITIATE_DESCRIPTION = "spInitiateDescription";
    private String spInitiateDescription;

    public TestInfoSamlTestConfiguration idp(Boolean idp) {
        this.idp = idp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if your integration supports IdP-initiated sign-in")
    @JsonProperty(value="idp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIdp() {
        return this.idp;
    }

    @JsonProperty(value="idp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdp(Boolean idp) {
        this.idp = idp;
    }

    public TestInfoSamlTestConfiguration sp(Boolean sp) {
        this.sp = sp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if your integration supports SP-initiated sign-in")
    @JsonProperty(value="sp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSp() {
        return this.sp;
    }

    @JsonProperty(value="sp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSp(Boolean sp) {
        this.sp = sp;
    }

    public TestInfoSamlTestConfiguration jit(Boolean jit) {
        this.jit = jit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if your integration supports Just-In-Time (JIT) provisioning")
    @JsonProperty(value="jit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getJit() {
        return this.jit;
    }

    @JsonProperty(value="jit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJit(Boolean jit) {
        this.jit = jit;
    }

    public TestInfoSamlTestConfiguration spInitiateUrl(URI spInitiateUrl) {
        this.spInitiateUrl = spInitiateUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://test.example.com/strawberry/saml/sp-init", required=true, value="URL for SP-initiated sign-in flows (required if `sp = true`)")
    @JsonProperty(value="spInitiateUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getSpInitiateUrl() {
        return this.spInitiateUrl;
    }

    @JsonProperty(value="spInitiateUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSpInitiateUrl(URI spInitiateUrl) {
        this.spInitiateUrl = spInitiateUrl;
    }

    public TestInfoSamlTestConfiguration spInitiateDescription(String spInitiateDescription) {
        this.spInitiateDescription = spInitiateDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Go to the app URL from a browser and enter your username", value="Instructions on how to sign in to your app using the SP-initiated flow (required if `sp = true`)")
    @JsonProperty(value="spInitiateDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSpInitiateDescription() {
        return this.spInitiateDescription;
    }

    @JsonProperty(value="spInitiateDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpInitiateDescription(String spInitiateDescription) {
        this.spInitiateDescription = spInitiateDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestInfoSamlTestConfiguration testInfoSamlTestConfiguration = (TestInfoSamlTestConfiguration)o;
        return Objects.equals(this.idp, testInfoSamlTestConfiguration.idp) && Objects.equals(this.sp, testInfoSamlTestConfiguration.sp) && Objects.equals(this.jit, testInfoSamlTestConfiguration.jit) && Objects.equals(this.spInitiateUrl, testInfoSamlTestConfiguration.spInitiateUrl) && Objects.equals(this.spInitiateDescription, testInfoSamlTestConfiguration.spInitiateDescription);
    }

    public int hashCode() {
        return Objects.hash(this.idp, this.sp, this.jit, this.spInitiateUrl, this.spInitiateDescription);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestInfoSamlTestConfiguration {\n");
        sb.append("    idp: ").append(this.toIndentedString(this.idp)).append("\n");
        sb.append("    sp: ").append(this.toIndentedString(this.sp)).append("\n");
        sb.append("    jit: ").append(this.toIndentedString(this.jit)).append("\n");
        sb.append("    spInitiateUrl: ").append(this.toIndentedString(this.spInitiateUrl)).append("\n");
        sb.append("    spInitiateDescription: ").append(this.toIndentedString(this.spInitiateDescription)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

