/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"contactType", "contactValueType", "contact"})
@JsonTypeName(value="SubmissionResponse_appContactDetails_inner")
public class SubmissionResponseAppContactDetailsInner
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CONTACT_TYPE = "contactType";
    private ContactTypeEnum contactType;
    public static final String JSON_PROPERTY_CONTACT_VALUE_TYPE = "contactValueType";
    private ContactValueTypeEnum contactValueType;
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private String contact;

    public SubmissionResponseAppContactDetailsInner contactType(ContactTypeEnum contactType) {
        this.contactType = contactType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="CUSTOMER_SUPPORT", required=true, value="Type of contact * `CUSTOMER_SUPPORT` - Public support contact details visible on your OIN catalog page for end users needing assistance with your integration. * `ESCALATION_SUPPORT` - Private support contact used by Okta to reach your organization during emergencies or escalations post-publication of the app (not shared with customers). ")
    @JsonProperty(value="contactType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactTypeEnum getContactType() {
        return this.contactType;
    }

    @JsonProperty(value="contactType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContactType(ContactTypeEnum contactType) {
        this.contactType = contactType;
    }

    public SubmissionResponseAppContactDetailsInner contactValueType(ContactValueTypeEnum contactValueType) {
        this.contactValueType = contactValueType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="EMAIL", required=true, value="Format of the contact value")
    @JsonProperty(value="contactValueType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactValueTypeEnum getContactValueType() {
        return this.contactValueType;
    }

    @JsonProperty(value="contactValueType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContactValueType(ContactValueTypeEnum contactValueType) {
        this.contactValueType = contactValueType;
    }

    public SubmissionResponseAppContactDetailsInner contact(String contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="support@example.com", required=true, value="The contact value (email, phone, or URL)")
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(String contact) {
        this.contact = contact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmissionResponseAppContactDetailsInner submissionResponseAppContactDetailsInner = (SubmissionResponseAppContactDetailsInner)o;
        return Objects.equals((Object)this.contactType, (Object)submissionResponseAppContactDetailsInner.contactType) && Objects.equals((Object)this.contactValueType, (Object)submissionResponseAppContactDetailsInner.contactValueType) && Objects.equals(this.contact, submissionResponseAppContactDetailsInner.contact);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contactType, this.contactValueType, this.contact});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubmissionResponseAppContactDetailsInner {\n");
        sb.append("    contactType: ").append(this.toIndentedString((Object)this.contactType)).append("\n");
        sb.append("    contactValueType: ").append(this.toIndentedString((Object)this.contactValueType)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ContactTypeEnum {
        CUSTOMER_SUPPORT(String.valueOf("CUSTOMER_SUPPORT")),
        ESCALATION_SUPPORT(String.valueOf("ESCALATION_SUPPORT")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ContactTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContactTypeEnum fromValue(String value) {
            for (ContactTypeEnum b : ContactTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ContactValueTypeEnum {
        URL(String.valueOf("URL")),
        EMAIL(String.valueOf("EMAIL")),
        PHONE(String.valueOf("PHONE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ContactValueTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContactValueTypeEnum fromValue(String value) {
            for (ContactValueTypeEnum b : ContactValueTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

