/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.AuthSettings;
import com.okta.sdk.resource.model.ProvisioningDetails;
import com.okta.sdk.resource.model.Sso;
import com.okta.sdk.resource.model.SubmissionAction;
import com.okta.sdk.resource.model.SubmissionCapability;
import com.okta.sdk.resource.model.SubmissionResponseAppContactDetailsInner;
import com.okta.sdk.resource.model.SubmissionResponseConfigInner;
import com.okta.sdk.resource.model.SubmissionResponseGlobalTokenRevocation;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"actions", "appContactDetails", "authSettings", "capabilities", "config", "description", "globalTokenRevocation", "id", "lastPublished", "lastUpdated", "lastUpdatedBy", "logo", "name", "provisioning", "sso", "status"})
public class SubmissionRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private List<SubmissionAction> actions = null;
    public static final String JSON_PROPERTY_APP_CONTACT_DETAILS = "appContactDetails";
    private List<SubmissionResponseAppContactDetailsInner> appContactDetails = null;
    public static final String JSON_PROPERTY_AUTH_SETTINGS = "authSettings";
    private AuthSettings authSettings;
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private List<SubmissionCapability> capabilities = null;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private List<SubmissionResponseConfigInner> config = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_GLOBAL_TOKEN_REVOCATION = "globalTokenRevocation";
    private SubmissionResponseGlobalTokenRevocation globalTokenRevocation;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_PUBLISHED = "lastPublished";
    private String lastPublished;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;
    public static final String JSON_PROPERTY_LAST_UPDATED_BY = "lastUpdatedBy";
    private String lastUpdatedBy;
    public static final String JSON_PROPERTY_LOGO = "logo";
    private URI logo;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROVISIONING = "provisioning";
    private ProvisioningDetails provisioning;
    public static final String JSON_PROPERTY_SSO = "sso";
    private Sso sso;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;

    public SubmissionRequest actions(List<SubmissionAction> actions) {
        this.actions = actions;
        return this;
    }

    public SubmissionRequest addactionsItem(SubmissionAction actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<SubmissionAction>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of actions supported by this integration")
    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubmissionAction> getActions() {
        return this.actions;
    }

    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActions(List<SubmissionAction> actions) {
        this.actions = actions;
    }

    public SubmissionRequest appContactDetails(List<SubmissionResponseAppContactDetailsInner> appContactDetails) {
        this.appContactDetails = appContactDetails;
        return this;
    }

    public SubmissionRequest addappContactDetailsItem(SubmissionResponseAppContactDetailsInner appContactDetailsItem) {
        if (this.appContactDetails == null) {
            this.appContactDetails = new ArrayList<SubmissionResponseAppContactDetailsInner>();
        }
        this.appContactDetails.add(appContactDetailsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of contact details for the app integration")
    @JsonProperty(value="appContactDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubmissionResponseAppContactDetailsInner> getAppContactDetails() {
        return this.appContactDetails;
    }

    @JsonProperty(value="appContactDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppContactDetails(List<SubmissionResponseAppContactDetailsInner> appContactDetails) {
        this.appContactDetails = appContactDetails;
    }

    public SubmissionRequest authSettings(AuthSettings authSettings) {
        this.authSettings = authSettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="authSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthSettings getAuthSettings() {
        return this.authSettings;
    }

    @JsonProperty(value="authSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthSettings(AuthSettings authSettings) {
        this.authSettings = authSettings;
    }

    public SubmissionRequest capabilities(List<SubmissionCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public SubmissionRequest addcapabilitiesItem(SubmissionCapability capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<SubmissionCapability>();
        }
        this.capabilities.add(capabilitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of capabilities supported by this integration")
    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubmissionCapability> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(List<SubmissionCapability> capabilities) {
        this.capabilities = capabilities;
    }

    public SubmissionRequest config(List<SubmissionResponseConfigInner> config) {
        this.config = config;
        return this;
    }

    public SubmissionRequest addconfigItem(SubmissionResponseConfigInner configItem) {
        if (this.config == null) {
            this.config = new ArrayList<SubmissionResponseConfigInner>();
        }
        this.config.add(configItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of org-level variables for the customer per-tenant configuration. For example, a `subdomain` variable can be used in the ACS URL: `https://${org.subdomain}.example.com/saml/login`")
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubmissionResponseConfigInner> getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfig(List<SubmissionResponseConfigInner> config) {
        this.config = config;
    }

    public SubmissionRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Your one source for in-season strawberry deals. Okta's Strawberry Central integration allow users to securely access those sweet deals.", required=true, value="A general description of your application and the benefits provided to your customers")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public SubmissionRequest globalTokenRevocation(SubmissionResponseGlobalTokenRevocation globalTokenRevocation) {
        this.globalTokenRevocation = globalTokenRevocation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="globalTokenRevocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubmissionResponseGlobalTokenRevocation getGlobalTokenRevocation() {
        return this.globalTokenRevocation;
    }

    @JsonProperty(value="globalTokenRevocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGlobalTokenRevocation(SubmissionResponseGlobalTokenRevocation globalTokenRevocation) {
        this.globalTokenRevocation = globalTokenRevocation;
    }

    @Nullable
    @ApiModelProperty(example="acme_submissionapp_1", value="OIN Integration ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="2023-08-24T14:15:22.000Z", value="Timestamp when the OIN Integration was last published")
    @JsonProperty(value="lastPublished")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastPublished() {
        return this.lastPublished;
    }

    @Nullable
    @ApiModelProperty(example="2023-08-24T14:15:22.000Z", value="Timestamp when the OIN Integration instance was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    @Nullable
    @ApiModelProperty(example="00ub0oNGTSWTBKOLGLNR", value="ID of the user who made the last update")
    @JsonProperty(value="lastUpdatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public SubmissionRequest logo(URI logo) {
        this.logo = logo;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://acme.okta.com/bc/image/fileStoreRecord?id=fs03xxd3KmkDBwJU80g4", required=true, value="URL to an uploaded application logo. This logo appears next to your app integration name in the OIN catalog. You must first [Upload an OIN Integration logo](/openapi/okta-management/management/tag/YourOinIntegrations/#tag/YourOinIntegrations/operation/uploadSubmissionLogo) to obtain the logo URL before you can specify this value.")
    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getLogo() {
        return this.logo;
    }

    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLogo(URI logo) {
        this.logo = logo;
    }

    public SubmissionRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Strawberry Central", required=true, value="The app integration name. This is the main title used for your integration in the OIN catalog.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public SubmissionRequest provisioning(ProvisioningDetails provisioning) {
        this.provisioning = provisioning;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="provisioning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProvisioningDetails getProvisioning() {
        return this.provisioning;
    }

    @JsonProperty(value="provisioning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvisioning(ProvisioningDetails provisioning) {
        this.provisioning = provisioning;
    }

    public SubmissionRequest sso(Sso sso) {
        this.sso = sso;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="sso")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Sso getSso() {
        return this.sso;
    }

    @JsonProperty(value="sso")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSso(Sso sso) {
        this.sso = sso;
    }

    @Nullable
    @ApiModelProperty(example="New", value="Status of the OIN Integration submission")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmissionRequest submissionRequest = (SubmissionRequest)o;
        return Objects.equals(this.actions, submissionRequest.actions) && Objects.equals(this.appContactDetails, submissionRequest.appContactDetails) && Objects.equals(this.authSettings, submissionRequest.authSettings) && Objects.equals(this.capabilities, submissionRequest.capabilities) && Objects.equals(this.config, submissionRequest.config) && Objects.equals(this.description, submissionRequest.description) && Objects.equals(this.globalTokenRevocation, submissionRequest.globalTokenRevocation) && Objects.equals(this.id, submissionRequest.id) && Objects.equals(this.lastPublished, submissionRequest.lastPublished) && Objects.equals(this.lastUpdated, submissionRequest.lastUpdated) && Objects.equals(this.lastUpdatedBy, submissionRequest.lastUpdatedBy) && Objects.equals(this.logo, submissionRequest.logo) && Objects.equals(this.name, submissionRequest.name) && Objects.equals(this.provisioning, submissionRequest.provisioning) && Objects.equals(this.sso, submissionRequest.sso) && Objects.equals(this.status, submissionRequest.status);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.appContactDetails, this.authSettings, this.capabilities, this.config, this.description, this.globalTokenRevocation, this.id, this.lastPublished, this.lastUpdated, this.lastUpdatedBy, this.logo, this.name, this.provisioning, this.sso, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubmissionRequest {\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    appContactDetails: ").append(this.toIndentedString(this.appContactDetails)).append("\n");
        sb.append("    authSettings: ").append(this.toIndentedString(this.authSettings)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    globalTokenRevocation: ").append(this.toIndentedString(this.globalTokenRevocation)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastPublished: ").append(this.toIndentedString(this.lastPublished)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    lastUpdatedBy: ").append(this.toIndentedString(this.lastUpdatedBy)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    provisioning: ").append(this.toIndentedString(this.provisioning)).append("\n");
        sb.append("    sso: ").append(this.toIndentedString(this.sso)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

