/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Information about the Security Events Provider for signal ingestion")
@JsonPropertyOrder(value={"well_known_url", "issuer", "jwks_url"})
@JsonTypeName(value="SecurityEventsProviderRequest_settings")
public class SecurityEventsProviderRequestSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_WELL_KNOWN_URL = "well_known_url";
    private String wellKnownUrl;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;
    public static final String JSON_PROPERTY_JWKS_URL = "jwks_url";
    private String jwksUrl;

    public SecurityEventsProviderRequestSettings wellKnownUrl(String wellKnownUrl) {
        this.wellKnownUrl = wellKnownUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://example.okta.com/.well-known/ssf-configuration", required=true, value="The published well-known URL of the Security Events Provider (the SSF transmitter)")
    @JsonProperty(value="well_known_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getWellKnownUrl() {
        return this.wellKnownUrl;
    }

    @JsonProperty(value="well_known_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWellKnownUrl(String wellKnownUrl) {
        this.wellKnownUrl = wellKnownUrl;
    }

    public SecurityEventsProviderRequestSettings issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="example.okta.com", required=true, value="Issuer URL")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public SecurityEventsProviderRequestSettings jwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://example.okta.com/oauth2/v1/keys", required=true, value="The public URL where the JWKS public key is uploaded")
    @JsonProperty(value="jwks_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getJwksUrl() {
        return this.jwksUrl;
    }

    @JsonProperty(value="jwks_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityEventsProviderRequestSettings securityEventsProviderRequestSettings = (SecurityEventsProviderRequestSettings)o;
        return Objects.equals(this.wellKnownUrl, securityEventsProviderRequestSettings.wellKnownUrl) && Objects.equals(this.issuer, securityEventsProviderRequestSettings.issuer) && Objects.equals(this.jwksUrl, securityEventsProviderRequestSettings.jwksUrl);
    }

    public int hashCode() {
        return Objects.hash(this.wellKnownUrl, this.issuer, this.jwksUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventsProviderRequestSettings {\n");
        sb.append("    wellKnownUrl: ").append(this.toIndentedString(this.wellKnownUrl)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    jwksUrl: ").append(this.toIndentedString(this.jwksUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

