/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.EntitlementTypesInner;
import com.okta.sdk.resource.model.ScimScimServerConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="SCIM configuration details")
@JsonPropertyOrder(value={"authMode", "baseUri", "entitlementTypes", "scimServerConfig", "setupInstructionsUri"})
public class Scim
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTH_MODE = "authMode";
    private String authMode;
    public static final String JSON_PROPERTY_BASE_URI = "baseUri";
    private URI baseUri;
    public static final String JSON_PROPERTY_ENTITLEMENT_TYPES = "entitlementTypes";
    private List<EntitlementTypesInner> entitlementTypes = null;
    public static final String JSON_PROPERTY_SCIM_SERVER_CONFIG = "scimServerConfig";
    private ScimScimServerConfig scimServerConfig;
    public static final String JSON_PROPERTY_SETUP_INSTRUCTIONS_URI = "setupInstructionsUri";
    private URI setupInstructionsUri;

    public Scim authMode(String authMode) {
        this.authMode = authMode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="header", required=true, value="The authentication mode for requests to your SCIM server  | authMode | Description | | -------- | ----------- | | `header` | Uses authorization header with a customer-provided token value in the following format: `Authorization: {API token}` | | `bearer` | Uses authorization header with a customer-provided bearer token in the following format: `Authorization: Bearer {API token}` | | {authModeId} | The ID of the auth mode object that contains OAuth 2.0 credentials. <br> **Note:** Use the `/integrations/api/v1/internal/authModes` endpoint to create the auth mode object. |")
    @JsonProperty(value="authMode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAuthMode() {
        return this.authMode;
    }

    @JsonProperty(value="authMode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public Scim baseUri(URI baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The base URL that Okta uses to send outbound calls to your SCIM server. Only the HTTPS protocol is supported. You can use the app-level variables defined in the `config` array for the base URL. For example, if you have a `subdomain` variable defined in the `config` array and the URL to retrieve SCIM users for your integration is `https://${subdomain}.example.com/scim/v2/Users`, then specify the following base URL: `'https://' + app.subdomain + '.example.com/scim/v2'`.")
    @JsonProperty(value="baseUri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getBaseUri() {
        return this.baseUri;
    }

    @JsonProperty(value="baseUri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    public Scim entitlementTypes(List<EntitlementTypesInner> entitlementTypes) {
        this.entitlementTypes = entitlementTypes;
        return this;
    }

    public Scim addentitlementTypesItem(EntitlementTypesInner entitlementTypesItem) {
        if (this.entitlementTypes == null) {
            this.entitlementTypes = new ArrayList<EntitlementTypesInner>();
        }
        this.entitlementTypes.add(entitlementTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of supported entitlement types")
    @JsonProperty(value="entitlementTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntitlementTypesInner> getEntitlementTypes() {
        return this.entitlementTypes;
    }

    @JsonProperty(value="entitlementTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntitlementTypes(List<EntitlementTypesInner> entitlementTypes) {
        this.entitlementTypes = entitlementTypes;
    }

    public Scim scimServerConfig(ScimScimServerConfig scimServerConfig) {
        this.scimServerConfig = scimServerConfig;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="scimServerConfig")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ScimScimServerConfig getScimServerConfig() {
        return this.scimServerConfig;
    }

    @JsonProperty(value="scimServerConfig")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScimServerConfig(ScimScimServerConfig scimServerConfig) {
        this.scimServerConfig = scimServerConfig;
    }

    public Scim setupInstructionsUri(URI setupInstructionsUri) {
        this.setupInstructionsUri = setupInstructionsUri;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The URL to your customer-facing instructions for configuring your SCIM integration. See [Customer configuration document guidelines](https://developer.okta.com/docs/guides/submit-app-prereq/main/#customer-configuration-document-guidelines).")
    @JsonProperty(value="setupInstructionsUri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getSetupInstructionsUri() {
        return this.setupInstructionsUri;
    }

    @JsonProperty(value="setupInstructionsUri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSetupInstructionsUri(URI setupInstructionsUri) {
        this.setupInstructionsUri = setupInstructionsUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scim scim = (Scim)o;
        return Objects.equals(this.authMode, scim.authMode) && Objects.equals(this.baseUri, scim.baseUri) && Objects.equals(this.entitlementTypes, scim.entitlementTypes) && Objects.equals(this.scimServerConfig, scim.scimServerConfig) && Objects.equals(this.setupInstructionsUri, scim.setupInstructionsUri);
    }

    public int hashCode() {
        return Objects.hash(this.authMode, this.baseUri, this.entitlementTypes, this.scimServerConfig, this.setupInstructionsUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Scim {\n");
        sb.append("    authMode: ").append(this.toIndentedString(this.authMode)).append("\n");
        sb.append("    baseUri: ").append(this.toIndentedString(this.baseUri)).append("\n");
        sb.append("    entitlementTypes: ").append(this.toIndentedString(this.entitlementTypes)).append("\n");
        sb.append("    scimServerConfig: ").append(this.toIndentedString(this.scimServerConfig)).append("\n");
        sb.append("    setupInstructionsUri: ").append(this.toIndentedString(this.setupInstructionsUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

