/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ProtocolEndpointBinding;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IdP's `SingleSignOnService` endpoint where Okta sends an `<AuthnRequest>` message")
@JsonPropertyOrder(value={"binding", "destination", "url"})
public class SamlSsoEndpoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_BINDING = "binding";
    private ProtocolEndpointBinding binding;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private String destination;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public SamlSsoEndpoint binding(ProtocolEndpointBinding binding) {
        this.binding = binding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="binding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolEndpointBinding getBinding() {
        return this.binding;
    }

    @JsonProperty(value="binding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBinding(ProtocolEndpointBinding binding) {
        this.binding = binding;
    }

    public SamlSsoEndpoint destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://idp.example.com/saml2/sso", value="URI reference that indicates the address to which the `<AuthnRequest>` message is sent. The `destination` property is required if request signatures are specified. See [SAML 2.0 Request Algorithm object](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path=protocol/0/algorithms/request&t=request).")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestination(String destination) {
        this.destination = destination;
    }

    public SamlSsoEndpoint url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://idp.example.com/saml2/sso", value="URL of the binding-specific endpoint to send an `<AuthnRequest>` message to the IdP. The value of `url` defaults to the same value as the `sso` endpoint if omitted during creation of a new IdP instance. The `url` should be the same value as the `Location` attribute for a published binding in the IdP's SAML Metadata `IDPSSODescriptor`.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlSsoEndpoint samlSsoEndpoint = (SamlSsoEndpoint)o;
        return Objects.equals((Object)this.binding, (Object)samlSsoEndpoint.binding) && Objects.equals(this.destination, samlSsoEndpoint.destination) && Objects.equals(this.url, samlSsoEndpoint.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.binding, this.destination, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlSsoEndpoint {\n");
        sb.append("    binding: ").append(this.toIndentedString((Object)this.binding)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

