/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ProtocolEndpointBinding;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IdP's `SingleLogoutService` endpoint where Okta sends a `<LogoutRequest>` message")
@JsonPropertyOrder(value={"binding", "url"})
public class SamlSloEndpoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_BINDING = "binding";
    private ProtocolEndpointBinding binding;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public SamlSloEndpoint binding(ProtocolEndpointBinding binding) {
        this.binding = binding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="binding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolEndpointBinding getBinding() {
        return this.binding;
    }

    @JsonProperty(value="binding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBinding(ProtocolEndpointBinding binding) {
        this.binding = binding;
    }

    public SamlSloEndpoint url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://idp.example.com/saml2/slo", value="URL of the binding-specific IdP endpoint where Okta sends a `<LogoutRequest>`")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlSloEndpoint samlSloEndpoint = (SamlSloEndpoint)o;
        return Objects.equals((Object)this.binding, (Object)samlSloEndpoint.binding) && Objects.equals(this.url, samlSloEndpoint.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.binding, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlSloEndpoint {\n");
        sb.append("    binding: ").append(this.toIndentedString((Object)this.binding)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

