/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Salesforce app instance properties")
@JsonPropertyOrder(value={"instanceType", "integrationType", "loginUrl", "logoutUrl"})
public class SalesforceApplicationSettingsApplication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_INSTANCE_TYPE = "instanceType";
    private InstanceTypeEnum instanceType;
    public static final String JSON_PROPERTY_INTEGRATION_TYPE = "integrationType";
    private IntegrationTypeEnum integrationType;
    public static final String JSON_PROPERTY_LOGIN_URL = "loginUrl";
    private String loginUrl;
    public static final String JSON_PROPERTY_LOGOUT_URL = "logoutUrl";
    private String logoutUrl;

    public SalesforceApplicationSettingsApplication instanceType(InstanceTypeEnum instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Salesforce instance that you want to connect to")
    @JsonProperty(value="instanceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public InstanceTypeEnum getInstanceType() {
        return this.instanceType;
    }

    @JsonProperty(value="instanceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInstanceType(InstanceTypeEnum instanceType) {
        this.instanceType = instanceType;
    }

    public SalesforceApplicationSettingsApplication integrationType(IntegrationTypeEnum integrationType) {
        this.integrationType = integrationType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Salesforce integration type")
    @JsonProperty(value="integrationType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IntegrationTypeEnum getIntegrationType() {
        return this.integrationType;
    }

    @JsonProperty(value="integrationType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIntegrationType(IntegrationTypeEnum integrationType) {
        this.integrationType = integrationType;
    }

    public SalesforceApplicationSettingsApplication loginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Login URL specified in your Salesforce Single Sign-On settings")
    @JsonProperty(value="loginUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLoginUrl() {
        return this.loginUrl;
    }

    @JsonProperty(value="loginUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public SalesforceApplicationSettingsApplication logoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Salesforce Logout URL")
    @JsonProperty(value="logoutUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    @JsonProperty(value="logoutUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SalesforceApplicationSettingsApplication salesforceApplicationSettingsApplication = (SalesforceApplicationSettingsApplication)o;
        return Objects.equals((Object)this.instanceType, (Object)salesforceApplicationSettingsApplication.instanceType) && Objects.equals((Object)this.integrationType, (Object)salesforceApplicationSettingsApplication.integrationType) && Objects.equals(this.loginUrl, salesforceApplicationSettingsApplication.loginUrl) && Objects.equals(this.logoutUrl, salesforceApplicationSettingsApplication.logoutUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.instanceType, this.integrationType, this.loginUrl, this.logoutUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalesforceApplicationSettingsApplication {\n");
        sb.append("    instanceType: ").append(this.toIndentedString((Object)this.instanceType)).append("\n");
        sb.append("    integrationType: ").append(this.toIndentedString((Object)this.integrationType)).append("\n");
        sb.append("    loginUrl: ").append(this.toIndentedString(this.loginUrl)).append("\n");
        sb.append("    logoutUrl: ").append(this.toIndentedString(this.logoutUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InstanceTypeEnum {
        SANDBOX(String.valueOf("SANDBOX")),
        PRODUCTION(String.valueOf("PRODUCTION")),
        GOVERNMENT(String.valueOf("GOVERNMENT")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private InstanceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InstanceTypeEnum fromValue(String value) {
            for (InstanceTypeEnum b : InstanceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum IntegrationTypeEnum {
        STANDARD(String.valueOf("STANDARD")),
        PORTAL(String.valueOf("PORTAL")),
        COMMUNITY(String.valueOf("COMMUNITY")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private IntegrationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IntegrationTypeEnum fromValue(String value) {
            for (IntegrationTypeEnum b : IntegrationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

