/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.ManagedConnectionAppInstance;
import com.okta.sdk.resource.model.ManagedConnectionServiceAccount;
import com.okta.sdk.resource.model.ManagedConnectionStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="STS connection to a service account")
@JsonPropertyOrder(value={"app", "connectionType", "id", "orn", "protocolType", "resourceIndicator", "serviceAccount", "status", "_links"})
public class STSServiceAccountConnection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP = "app";
    private ManagedConnectionAppInstance app;
    public static final String JSON_PROPERTY_CONNECTION_TYPE = "connectionType";
    private ConnectionTypeEnum connectionType;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;
    public static final String JSON_PROPERTY_PROTOCOL_TYPE = "protocolType";
    private ProtocolTypeEnum protocolType;
    public static final String JSON_PROPERTY_RESOURCE_INDICATOR = "resourceIndicator";
    private URI resourceIndicator;
    public static final String JSON_PROPERTY_SERVICE_ACCOUNT = "serviceAccount";
    private ManagedConnectionServiceAccount serviceAccount;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ManagedConnectionStatus status;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public STSServiceAccountConnection app(ManagedConnectionAppInstance app) {
        this.app = app;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="app")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ManagedConnectionAppInstance getApp() {
        return this.app;
    }

    @JsonProperty(value="app")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApp(ManagedConnectionAppInstance app) {
        this.app = app;
    }

    public STSServiceAccountConnection connectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Type of connection authentication method")
    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConnectionTypeEnum getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
    }

    public STSServiceAccountConnection id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the managed connection. Only present for managed connections.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public STSServiceAccountConnection orn(String orn) {
        this.orn = orn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The [ORN](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#okta-resource-name-orn) of the managed connection")
    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrn() {
        return this.orn;
    }

    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrn(String orn) {
        this.orn = orn;
    }

    public STSServiceAccountConnection protocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authentication protocol type used for the connection")
    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolTypeEnum getProtocolType() {
        return this.protocolType;
    }

    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
    }

    public STSServiceAccountConnection resourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Resource indicator used when requesting tokens.")
    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getResourceIndicator() {
        return this.resourceIndicator;
    }

    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
    }

    public STSServiceAccountConnection serviceAccount(ManagedConnectionServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="serviceAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ManagedConnectionServiceAccount getServiceAccount() {
        return this.serviceAccount;
    }

    @JsonProperty(value="serviceAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceAccount(ManagedConnectionServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public STSServiceAccountConnection status(ManagedConnectionStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ManagedConnectionStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ManagedConnectionStatus status) {
        this.status = status;
    }

    public STSServiceAccountConnection links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        STSServiceAccountConnection stSServiceAccountConnection = (STSServiceAccountConnection)o;
        return Objects.equals(this.app, stSServiceAccountConnection.app) && Objects.equals((Object)this.connectionType, (Object)stSServiceAccountConnection.connectionType) && Objects.equals(this.id, stSServiceAccountConnection.id) && Objects.equals(this.orn, stSServiceAccountConnection.orn) && Objects.equals((Object)this.protocolType, (Object)stSServiceAccountConnection.protocolType) && Objects.equals(this.resourceIndicator, stSServiceAccountConnection.resourceIndicator) && Objects.equals(this.serviceAccount, stSServiceAccountConnection.serviceAccount) && Objects.equals((Object)this.status, (Object)stSServiceAccountConnection.status) && Objects.equals(this.links, stSServiceAccountConnection.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.app, this.connectionType, this.id, this.orn, this.protocolType, this.resourceIndicator, this.serviceAccount, this.status, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class STSServiceAccountConnection {\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    connectionType: ").append(this.toIndentedString((Object)this.connectionType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    orn: ").append(this.toIndentedString(this.orn)).append("\n");
        sb.append("    protocolType: ").append(this.toIndentedString((Object)this.protocolType)).append("\n");
        sb.append("    resourceIndicator: ").append(this.toIndentedString(this.resourceIndicator)).append("\n");
        sb.append("    serviceAccount: ").append(this.toIndentedString(this.serviceAccount)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ConnectionTypeEnum {
        STS_SERVICE_ACCOUNT(String.valueOf("STS_SERVICE_ACCOUNT")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ConnectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionTypeEnum fromValue(String value) {
            for (ConnectionTypeEnum b : ConnectionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ProtocolTypeEnum {
        STS(String.valueOf("STS")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ProtocolTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolTypeEnum fromValue(String value) {
            for (ProtocolTypeEnum b : ProtocolTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

