/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Rotate password request for the privileged resource")
@JsonPropertyOrder(value={"password", "secretVersionId"})
public class RotatePasswordRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_SECRET_VERSION_ID = "secretVersionId";
    private String secretVersionId;

    public RotatePasswordRequest password(String password) {
        this.password = password;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="xf1bs9am2", required=true, value="The password associated with the privileged resource")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPassword(String password) {
        this.password = password;
    }

    public RotatePasswordRequest secretVersionId(String secretVersionId) {
        this.secretVersionId = secretVersionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="9f8400-e29b-41d4-a716-926655440034", required=true, value="The version ID of the password secret from the OPA vault")
    @JsonProperty(value="secretVersionId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSecretVersionId() {
        return this.secretVersionId;
    }

    @JsonProperty(value="secretVersionId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSecretVersionId(String secretVersionId) {
        this.secretVersionId = secretVersionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RotatePasswordRequest rotatePasswordRequest = (RotatePasswordRequest)o;
        return Objects.equals(this.password, rotatePasswordRequest.password) && Objects.equals(this.secretVersionId, rotatePasswordRequest.secretVersionId);
    }

    public int hashCode() {
        return Objects.hash(this.password, this.secretVersionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RotatePasswordRequest {\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    secretVersionId: ").append(this.toIndentedString(this.secretVersionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

