/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"domains", "name", "realmType"})
public class RealmProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    private List<String> domains = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_REALM_TYPE = "realmType";
    private RealmTypeEnum realmType;

    public RealmProfile domains(List<String> domains) {
        this.domains = domains;
        return this;
    }

    public RealmProfile adddomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of allowed domains. No user in this realm can be created or updated unless they have a username and email from one of these domains.  The following characters aren't allowed in the domain name: `!$%^&()=*+,:;<>'[]|/?\\`")
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public RealmProfile name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name of a realm")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public RealmProfile realmType(RealmTypeEnum realmType) {
        this.realmType = realmType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to store partner users. This property must be set to `PARTNER` to access Okta's external partner portal.")
    @JsonProperty(value="realmType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RealmTypeEnum getRealmType() {
        return this.realmType;
    }

    @JsonProperty(value="realmType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRealmType(RealmTypeEnum realmType) {
        this.realmType = realmType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealmProfile realmProfile = (RealmProfile)o;
        return Objects.equals(this.domains, realmProfile.domains) && Objects.equals(this.name, realmProfile.name) && Objects.equals((Object)this.realmType, (Object)realmProfile.realmType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.domains, this.name, this.realmType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RealmProfile {\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    realmType: ").append(this.toIndentedString((Object)this.realmType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RealmTypeEnum {
        PARTNER(String.valueOf("PARTNER")),
        DEFAULT(String.valueOf("DEFAULT")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private RealmTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RealmTypeEnum fromValue(String value) {
            for (RealmTypeEnum b : RealmTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

