/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IDVCredentials;
import com.okta.sdk.resource.model.IDVEndpoints;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Protocol settings for the IDV vendor")
@JsonPropertyOrder(value={"credentials", "endpoints", "scopes", "type"})
public class ProtocolIdVerification
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private IDVCredentials credentials;
    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    private IDVEndpoints endpoints;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public ProtocolIdVerification credentials(IDVCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IDVCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(IDVCredentials credentials) {
        this.credentials = credentials;
    }

    public ProtocolIdVerification endpoints(IDVEndpoints endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IDVEndpoints getEndpoints() {
        return this.endpoints;
    }

    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoints(IDVEndpoints endpoints) {
        this.endpoints = endpoints;
    }

    public ProtocolIdVerification scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public ProtocolIdVerification addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IdP-defined permission bundles to request delegated access from the user. > **Note:** The [identity provider type](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path=type&t=request) table lists the scopes that are supported for each IdP.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public ProtocolIdVerification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID verification protocol")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtocolIdVerification protocolIdVerification = (ProtocolIdVerification)o;
        return Objects.equals(this.credentials, protocolIdVerification.credentials) && Objects.equals(this.endpoints, protocolIdVerification.endpoints) && Objects.equals(this.scopes, protocolIdVerification.scopes) && Objects.equals((Object)this.type, (Object)protocolIdVerification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.credentials, this.endpoints, this.scopes, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProtocolIdVerification {\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ID_PROOFING(String.valueOf("ID_PROOFING")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

