/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Connection object for Cross App Access connections")
@JsonPropertyOrder(value={"created", "id", "lastUpdated", "requestingAppInstanceId", "resourceAppInstanceId", "status"})
public class OrgCrossAppAccessConnection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_REQUESTING_APP_INSTANCE_ID = "requestingAppInstanceId";
    private String requestingAppInstanceId;
    public static final String JSON_PROPERTY_RESOURCE_APP_INSTANCE_ID = "resourceAppInstanceId";
    private String resourceAppInstanceId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    @Nullable
    @ApiModelProperty(example="2024-10-15T10:30Z", value="The ISO 8601 formatted date and time when the connection was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(example="cwofxqCAJWWGELFTYASJ", value="Unique identifier for the connection")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="2024-10-15T14:20Z", value="The ISO 8601 formatted date and time when the connection was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public OrgCrossAppAccessConnection requestingAppInstanceId(String requestingAppInstanceId) {
        this.requestingAppInstanceId = requestingAppInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0oafxqCAJWWGELFTYASJ", value="ID of the requesting app instance")
    @JsonProperty(value="requestingAppInstanceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestingAppInstanceId() {
        return this.requestingAppInstanceId;
    }

    @JsonProperty(value="requestingAppInstanceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestingAppInstanceId(String requestingAppInstanceId) {
        this.requestingAppInstanceId = requestingAppInstanceId;
    }

    public OrgCrossAppAccessConnection resourceAppInstanceId(String resourceAppInstanceId) {
        this.resourceAppInstanceId = resourceAppInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0oafxqCBJWWGELFTYASK", value="ID of the resource app instance")
    @JsonProperty(value="resourceAppInstanceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResourceAppInstanceId() {
        return this.resourceAppInstanceId;
    }

    @JsonProperty(value="resourceAppInstanceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceAppInstanceId(String resourceAppInstanceId) {
        this.resourceAppInstanceId = resourceAppInstanceId;
    }

    public OrgCrossAppAccessConnection status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="Indicates if the Cross App Access connection is active or inactive")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrgCrossAppAccessConnection orgCrossAppAccessConnection = (OrgCrossAppAccessConnection)o;
        return Objects.equals(this.created, orgCrossAppAccessConnection.created) && Objects.equals(this.id, orgCrossAppAccessConnection.id) && Objects.equals(this.lastUpdated, orgCrossAppAccessConnection.lastUpdated) && Objects.equals(this.requestingAppInstanceId, orgCrossAppAccessConnection.requestingAppInstanceId) && Objects.equals(this.resourceAppInstanceId, orgCrossAppAccessConnection.resourceAppInstanceId) && Objects.equals((Object)this.status, (Object)orgCrossAppAccessConnection.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.id, this.lastUpdated, this.requestingAppInstanceId, this.resourceAppInstanceId, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgCrossAppAccessConnection {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    requestingAppInstanceId: ").append(this.toIndentedString(this.requestingAppInstanceId)).append("\n");
        sb.append("    resourceAppInstanceId: ").append(this.toIndentedString(this.resourceAppInstanceId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

