/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"completed", "created", "id", "started", "status", "type"})
public class OperationResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_COMPLETED = "completed";
    private OffsetDateTime completed;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_STARTED = "started";
    private OffsetDateTime started;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public OperationResponse completed(OffsetDateTime completed) {
        this.completed = completed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp of when the operation completed")
    @JsonProperty(value="completed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCompleted() {
        return this.completed;
    }

    @JsonProperty(value="completed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompleted(OffsetDateTime completed) {
        this.completed = completed;
    }

    public OperationResponse created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Timestamp of when the operation was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public OperationResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ID of the asynchronous operation")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public OperationResponse started(OffsetDateTime started) {
        this.started = started;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp of when the operation started")
    @JsonProperty(value="started")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStarted() {
        return this.started;
    }

    @JsonProperty(value="started")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStarted(OffsetDateTime started) {
        this.started = started;
    }

    public OperationResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The status of the asynchronous operation")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OperationResponse type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The operation type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationResponse operationResponse = (OperationResponse)o;
        return Objects.equals(this.completed, operationResponse.completed) && Objects.equals(this.created, operationResponse.created) && Objects.equals(this.id, operationResponse.id) && Objects.equals(this.started, operationResponse.started) && Objects.equals((Object)this.status, (Object)operationResponse.status) && Objects.equals(this.type, operationResponse.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.completed, this.created, this.id, this.started, this.status, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationResponse {\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        COMPLETED(String.valueOf("COMPLETED")),
        SCHEDULED(String.valueOf("SCHEDULED")),
        IN_PROGRESS(String.valueOf("IN_PROGRESS")),
        FAILED(String.valueOf("FAILED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

