/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Profile for a group that is imported from Active Directory.  The `objectClass` for such groups is `okta:windows_security_principal`.")
@JsonPropertyOrder(value={"description", "dn", "externalId", "groupScope", "groupType", "managedBy", "name", "objectClass", "objectSid", "samAccountName", "windowsDomainQualifiedName"})
public class OktaActiveDirectoryGroupProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DN = "dn";
    private String dn;
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private String externalId;
    public static final String JSON_PROPERTY_GROUP_SCOPE = "groupScope";
    private String groupScope;
    public static final String JSON_PROPERTY_GROUP_TYPE = "groupType";
    private String groupType;
    public static final String JSON_PROPERTY_MANAGED_BY = "managedBy";
    private JsonNullable<String> managedBy = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OBJECT_CLASS = "objectClass";
    private ObjectClassEnum objectClass;
    public static final String JSON_PROPERTY_OBJECT_SID = "objectSid";
    private String objectSid;
    public static final String JSON_PROPERTY_SAM_ACCOUNT_NAME = "samAccountName";
    private String samAccountName;
    public static final String JSON_PROPERTY_WINDOWS_DOMAIN_QUALIFIED_NAME = "windowsDomainQualifiedName";
    private String windowsDomainQualifiedName;

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public OktaActiveDirectoryGroupProfile description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="All users in the engineering department", value="Description of the Windows group")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public OktaActiveDirectoryGroupProfile dn(String dn) {
        this.dn = dn;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CN=West Coast users,OU=West Coast,DC=example,DC=com", value="The distinguished name of the Windows group")
    @JsonProperty(value="dn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDn() {
        return this.dn;
    }

    @JsonProperty(value="dn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDn(String dn) {
        this.dn = dn;
    }

    public OktaActiveDirectoryGroupProfile externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="VKzYZ1C+IkSZxIWlrW5ITg==", value="Base-64 encoded GUID (`objectGUID`) of the Windows group")
    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public OktaActiveDirectoryGroupProfile groupScope(String groupScope) {
        this.groupScope = groupScope;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Global", value="The scope of the Windows group (DomainLocal, Global, or Universal)")
    @JsonProperty(value="groupScope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupScope() {
        return this.groupScope;
    }

    @JsonProperty(value="groupScope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupScope(String groupScope) {
        this.groupScope = groupScope;
    }

    public OktaActiveDirectoryGroupProfile groupType(String groupType) {
        this.groupType = groupType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Security", value="The type of the Windows group (Security or Distribution)")
    @JsonProperty(value="groupType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupType() {
        return this.groupType;
    }

    @JsonProperty(value="groupType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public OktaActiveDirectoryGroupProfile managedBy(String managedBy) {
        this.managedBy = JsonNullable.of((Object)managedBy);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CN=IT Admin,CN=Users,DC=example,DC=com", value="Distinguished name of the group that manages this group")
    @JsonIgnore
    public String getManagedBy() {
        return (String)this.managedBy.orElse(null);
    }

    @JsonProperty(value="managedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getManagedBy_JsonNullable() {
        return this.managedBy;
    }

    @JsonProperty(value="managedBy")
    public void setManagedBy_JsonNullable(JsonNullable<String> managedBy) {
        this.managedBy = managedBy;
    }

    public void setManagedBy(String managedBy) {
        this.managedBy = JsonNullable.of((Object)managedBy);
    }

    public OktaActiveDirectoryGroupProfile name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="West Coast users", value="Name of the Windows group")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    @ApiModelProperty(example="okta:windows_security_principal", value="The object class type")
    @JsonProperty(value="objectClass")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ObjectClassEnum getObjectClass() {
        return this.objectClass;
    }

    public OktaActiveDirectoryGroupProfile objectSid(String objectSid) {
        this.objectSid = objectSid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="S-1-5-21-3623811015-3361044348-30300820-1013", value="The Windows Security Identifier (SID) for the group")
    @JsonProperty(value="objectSid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getObjectSid() {
        return this.objectSid;
    }

    @JsonProperty(value="objectSid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectSid(String objectSid) {
        this.objectSid = objectSid;
    }

    public OktaActiveDirectoryGroupProfile samAccountName(String samAccountName) {
        this.samAccountName = samAccountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="West Coast users", value="Pre-Windows 2000 name of the Windows group")
    @JsonProperty(value="samAccountName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSamAccountName() {
        return this.samAccountName;
    }

    @JsonProperty(value="samAccountName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSamAccountName(String samAccountName) {
        this.samAccountName = samAccountName;
    }

    public OktaActiveDirectoryGroupProfile windowsDomainQualifiedName(String windowsDomainQualifiedName) {
        this.windowsDomainQualifiedName = windowsDomainQualifiedName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="EXAMPLE\\\\West Coast users", value="Fully qualified name of the Windows group")
    @JsonProperty(value="windowsDomainQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWindowsDomainQualifiedName() {
        return this.windowsDomainQualifiedName;
    }

    @JsonProperty(value="windowsDomainQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWindowsDomainQualifiedName(String windowsDomainQualifiedName) {
        this.windowsDomainQualifiedName = windowsDomainQualifiedName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OktaActiveDirectoryGroupProfile oktaActiveDirectoryGroupProfile = (OktaActiveDirectoryGroupProfile)o;
        return Objects.equals(this.description, oktaActiveDirectoryGroupProfile.description) && Objects.equals(this.dn, oktaActiveDirectoryGroupProfile.dn) && Objects.equals(this.externalId, oktaActiveDirectoryGroupProfile.externalId) && Objects.equals(this.groupScope, oktaActiveDirectoryGroupProfile.groupScope) && Objects.equals(this.groupType, oktaActiveDirectoryGroupProfile.groupType) && OktaActiveDirectoryGroupProfile.equalsNullable(this.managedBy, oktaActiveDirectoryGroupProfile.managedBy) && Objects.equals(this.name, oktaActiveDirectoryGroupProfile.name) && Objects.equals((Object)this.objectClass, (Object)oktaActiveDirectoryGroupProfile.objectClass) && Objects.equals(this.objectSid, oktaActiveDirectoryGroupProfile.objectSid) && Objects.equals(this.samAccountName, oktaActiveDirectoryGroupProfile.samAccountName) && Objects.equals(this.windowsDomainQualifiedName, oktaActiveDirectoryGroupProfile.windowsDomainQualifiedName) && super.equals(o);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.dn, this.externalId, this.groupScope, this.groupType, OktaActiveDirectoryGroupProfile.hashCodeNullable(this.managedBy), this.name, this.objectClass, this.objectSid, this.samAccountName, this.windowsDomainQualifiedName, super.hashCode()});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaActiveDirectoryGroupProfile {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dn: ").append(this.toIndentedString(this.dn)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    groupScope: ").append(this.toIndentedString(this.groupScope)).append("\n");
        sb.append("    groupType: ").append(this.toIndentedString(this.groupType)).append("\n");
        sb.append("    managedBy: ").append(this.toIndentedString(this.managedBy)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    objectClass: ").append(this.toIndentedString((Object)this.objectClass)).append("\n");
        sb.append("    objectSid: ").append(this.toIndentedString(this.objectSid)).append("\n");
        sb.append("    samAccountName: ").append(this.toIndentedString(this.samAccountName)).append("\n");
        sb.append("    windowsDomainQualifiedName: ").append(this.toIndentedString(this.windowsDomainQualifiedName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ObjectClassEnum {
        OKTA_WINDOWS_SECURITY_PRINCIPAL(String.valueOf("okta:windows_security_principal")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ObjectClassEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ObjectClassEnum fromValue(String value) {
            for (ObjectClassEnum b : ObjectClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

