/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="OIDC configuration details")
@JsonPropertyOrder(value={"doc", "initiateLoginUri", "postLogoutUris", "redirectUris"})
public class Oidc
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DOC = "doc";
    private URI doc;
    public static final String JSON_PROPERTY_INITIATE_LOGIN_URI = "initiateLoginUri";
    private URI initiateLoginUri;
    public static final String JSON_PROPERTY_POST_LOGOUT_URIS = "postLogoutUris";
    private List<URI> postLogoutUris = null;
    public static final String JSON_PROPERTY_REDIRECT_URIS = "redirectUris";
    private List<URI> redirectUris = new ArrayList<URI>();

    public Oidc doc(URI doc) {
        this.doc = doc;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://example.com/strawberry/help/oidcSetup", required=true, value="The URL to your customer-facing instructions for configuring your OIDC integration. See [Customer configuration document guidelines](https://developer.okta.com/docs/guides/submit-app-prereq/main/#customer-configuration-document-guidelines).")
    @JsonProperty(value="doc")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getDoc() {
        return this.doc;
    }

    @JsonProperty(value="doc")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDoc(URI doc) {
        this.doc = doc;
    }

    public Oidc initiateLoginUri(URI initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://{app.subdomain}.example.com/strawberry/oidc/sp-init", value="The URL to redirect users when they click on your app from their Okta End-User Dashboard")
    @JsonProperty(value="initiateLoginUri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    @JsonProperty(value="initiateLoginUri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitiateLoginUri(URI initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public Oidc postLogoutUris(List<URI> postLogoutUris) {
        this.postLogoutUris = postLogoutUris;
        return this;
    }

    public Oidc addpostLogoutUrisItem(URI postLogoutUrisItem) {
        if (this.postLogoutUris == null) {
            this.postLogoutUris = new ArrayList<URI>();
        }
        this.postLogoutUris.add(postLogoutUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sign-out redirect URIs for your app. You can send a request to `/v1/logout` to sign the user out and redirect them to one of these URIs.")
    @JsonProperty(value="postLogoutUris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<URI> getPostLogoutUris() {
        return this.postLogoutUris;
    }

    @JsonProperty(value="postLogoutUris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostLogoutUris(List<URI> postLogoutUris) {
        this.postLogoutUris = postLogoutUris;
    }

    public Oidc redirectUris(List<URI> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public Oidc addredirectUrisItem(URI redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<URI>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="List of sign-in redirect URIs")
    @JsonProperty(value="redirectUris")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<URI> getRedirectUris() {
        return this.redirectUris;
    }

    @JsonProperty(value="redirectUris")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRedirectUris(List<URI> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Oidc oidc = (Oidc)o;
        return Objects.equals(this.doc, oidc.doc) && Objects.equals(this.initiateLoginUri, oidc.initiateLoginUri) && Objects.equals(this.postLogoutUris, oidc.postLogoutUris) && Objects.equals(this.redirectUris, oidc.redirectUris);
    }

    public int hashCode() {
        return Objects.hash(this.doc, this.initiateLoginUri, this.postLogoutUris, this.redirectUris);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Oidc {\n");
        sb.append("    doc: ").append(this.toIndentedString(this.doc)).append("\n");
        sb.append("    initiateLoginUri: ").append(this.toIndentedString(this.initiateLoginUri)).append("\n");
        sb.append("    postLogoutUris: ").append(this.toIndentedString(this.postLogoutUris)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

