/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.SamlAttributeStatement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Contains SAML 2.0 sign-on mode attributes. > **Note:** Set `destinationOverride` to configure any other SAML 2.0 attributes in this section.")
@JsonPropertyOrder(value={"attributeStatements", "audienceOverride", "defaultRelayState", "destinationOverride", "recipientOverride", "samlAssertionLifetimeSeconds", "ssoAcsUrlOverride"})
public class OINSaml20ApplicationSettingsSignOn
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ATTRIBUTE_STATEMENTS = "attributeStatements";
    private List<SamlAttributeStatement> attributeStatements = null;
    public static final String JSON_PROPERTY_AUDIENCE_OVERRIDE = "audienceOverride";
    private JsonNullable<String> audienceOverride = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_RELAY_STATE = "defaultRelayState";
    private JsonNullable<String> defaultRelayState = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DESTINATION_OVERRIDE = "destinationOverride";
    private JsonNullable<String> destinationOverride = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RECIPIENT_OVERRIDE = "recipientOverride";
    private JsonNullable<String> recipientOverride = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SAML_ASSERTION_LIFETIME_SECONDS = "samlAssertionLifetimeSeconds";
    private Integer samlAssertionLifetimeSeconds;
    public static final String JSON_PROPERTY_SSO_ACS_URL_OVERRIDE = "ssoAcsUrlOverride";
    private JsonNullable<String> ssoAcsUrlOverride = JsonNullable.undefined();

    public OINSaml20ApplicationSettingsSignOn attributeStatements(List<SamlAttributeStatement> attributeStatements) {
        this.attributeStatements = attributeStatements;
        return this;
    }

    public OINSaml20ApplicationSettingsSignOn addattributeStatementsItem(SamlAttributeStatement attributeStatementsItem) {
        if (this.attributeStatements == null) {
            this.attributeStatements = new ArrayList<SamlAttributeStatement>();
        }
        this.attributeStatements.add(attributeStatementsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of custom attribute statements for the app's SAML assertion. See [SAML 2.0 Technical Overview](https://docs.oasis-open.org/security/saml/Post2.0/sstc-saml-tech-overview-2.0-cd-02.html).  There are two types of attribute statements: | Type | Description | | ---- | ----------- | | EXPRESSION | Generic attribute statement that can be dynamic and supports [Okta Expression Language](https://developer.okta.com/docs/reference/okta-expression-language/) | | GROUP | Group attribute statement | ")
    @JsonProperty(value="attributeStatements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SamlAttributeStatement> getAttributeStatements() {
        return this.attributeStatements;
    }

    @JsonProperty(value="attributeStatements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributeStatements(List<SamlAttributeStatement> attributeStatements) {
        this.attributeStatements = attributeStatements;
    }

    public OINSaml20ApplicationSettingsSignOn audienceOverride(String audienceOverride) {
        this.audienceOverride = JsonNullable.of((Object)audienceOverride);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Audience override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonIgnore
    public String getAudienceOverride() {
        return (String)this.audienceOverride.orElse(null);
    }

    @JsonProperty(value="audienceOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAudienceOverride_JsonNullable() {
        return this.audienceOverride;
    }

    @JsonProperty(value="audienceOverride")
    public void setAudienceOverride_JsonNullable(JsonNullable<String> audienceOverride) {
        this.audienceOverride = audienceOverride;
    }

    public void setAudienceOverride(String audienceOverride) {
        this.audienceOverride = JsonNullable.of((Object)audienceOverride);
    }

    public OINSaml20ApplicationSettingsSignOn defaultRelayState(String defaultRelayState) {
        this.defaultRelayState = JsonNullable.of((Object)defaultRelayState);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifies a specific application resource in an IdP-initiated SSO scenario")
    @JsonIgnore
    public String getDefaultRelayState() {
        return (String)this.defaultRelayState.orElse(null);
    }

    @JsonProperty(value="defaultRelayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDefaultRelayState_JsonNullable() {
        return this.defaultRelayState;
    }

    @JsonProperty(value="defaultRelayState")
    public void setDefaultRelayState_JsonNullable(JsonNullable<String> defaultRelayState) {
        this.defaultRelayState = defaultRelayState;
    }

    public void setDefaultRelayState(String defaultRelayState) {
        this.defaultRelayState = JsonNullable.of((Object)defaultRelayState);
    }

    public OINSaml20ApplicationSettingsSignOn destinationOverride(String destinationOverride) {
        this.destinationOverride = JsonNullable.of((Object)destinationOverride);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Destination override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonIgnore
    public String getDestinationOverride() {
        return (String)this.destinationOverride.orElse(null);
    }

    @JsonProperty(value="destinationOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDestinationOverride_JsonNullable() {
        return this.destinationOverride;
    }

    @JsonProperty(value="destinationOverride")
    public void setDestinationOverride_JsonNullable(JsonNullable<String> destinationOverride) {
        this.destinationOverride = destinationOverride;
    }

    public void setDestinationOverride(String destinationOverride) {
        this.destinationOverride = JsonNullable.of((Object)destinationOverride);
    }

    public OINSaml20ApplicationSettingsSignOn recipientOverride(String recipientOverride) {
        this.recipientOverride = JsonNullable.of((Object)recipientOverride);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Recipient override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonIgnore
    public String getRecipientOverride() {
        return (String)this.recipientOverride.orElse(null);
    }

    @JsonProperty(value="recipientOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getRecipientOverride_JsonNullable() {
        return this.recipientOverride;
    }

    @JsonProperty(value="recipientOverride")
    public void setRecipientOverride_JsonNullable(JsonNullable<String> recipientOverride) {
        this.recipientOverride = recipientOverride;
    }

    public void setRecipientOverride(String recipientOverride) {
        this.recipientOverride = JsonNullable.of((Object)recipientOverride);
    }

    public OINSaml20ApplicationSettingsSignOn samlAssertionLifetimeSeconds(Integer samlAssertionLifetimeSeconds) {
        this.samlAssertionLifetimeSeconds = samlAssertionLifetimeSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3600", value="Determines the SAML app session lifetimes with Okta")
    @JsonProperty(value="samlAssertionLifetimeSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSamlAssertionLifetimeSeconds() {
        return this.samlAssertionLifetimeSeconds;
    }

    @JsonProperty(value="samlAssertionLifetimeSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSamlAssertionLifetimeSeconds(Integer samlAssertionLifetimeSeconds) {
        this.samlAssertionLifetimeSeconds = samlAssertionLifetimeSeconds;
    }

    public OINSaml20ApplicationSettingsSignOn ssoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = JsonNullable.of((Object)ssoAcsUrlOverride);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Assertion Consumer Service (ACS) URL override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonIgnore
    public String getSsoAcsUrlOverride() {
        return (String)this.ssoAcsUrlOverride.orElse(null);
    }

    @JsonProperty(value="ssoAcsUrlOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSsoAcsUrlOverride_JsonNullable() {
        return this.ssoAcsUrlOverride;
    }

    @JsonProperty(value="ssoAcsUrlOverride")
    public void setSsoAcsUrlOverride_JsonNullable(JsonNullable<String> ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
    }

    public void setSsoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = JsonNullable.of((Object)ssoAcsUrlOverride);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OINSaml20ApplicationSettingsSignOn oiNSaml20ApplicationSettingsSignOn = (OINSaml20ApplicationSettingsSignOn)o;
        return Objects.equals(this.attributeStatements, oiNSaml20ApplicationSettingsSignOn.attributeStatements) && OINSaml20ApplicationSettingsSignOn.equalsNullable(this.audienceOverride, oiNSaml20ApplicationSettingsSignOn.audienceOverride) && OINSaml20ApplicationSettingsSignOn.equalsNullable(this.defaultRelayState, oiNSaml20ApplicationSettingsSignOn.defaultRelayState) && OINSaml20ApplicationSettingsSignOn.equalsNullable(this.destinationOverride, oiNSaml20ApplicationSettingsSignOn.destinationOverride) && OINSaml20ApplicationSettingsSignOn.equalsNullable(this.recipientOverride, oiNSaml20ApplicationSettingsSignOn.recipientOverride) && Objects.equals(this.samlAssertionLifetimeSeconds, oiNSaml20ApplicationSettingsSignOn.samlAssertionLifetimeSeconds) && OINSaml20ApplicationSettingsSignOn.equalsNullable(this.ssoAcsUrlOverride, oiNSaml20ApplicationSettingsSignOn.ssoAcsUrlOverride);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.attributeStatements, OINSaml20ApplicationSettingsSignOn.hashCodeNullable(this.audienceOverride), OINSaml20ApplicationSettingsSignOn.hashCodeNullable(this.defaultRelayState), OINSaml20ApplicationSettingsSignOn.hashCodeNullable(this.destinationOverride), OINSaml20ApplicationSettingsSignOn.hashCodeNullable(this.recipientOverride), this.samlAssertionLifetimeSeconds, OINSaml20ApplicationSettingsSignOn.hashCodeNullable(this.ssoAcsUrlOverride));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OINSaml20ApplicationSettingsSignOn {\n");
        sb.append("    attributeStatements: ").append(this.toIndentedString(this.attributeStatements)).append("\n");
        sb.append("    audienceOverride: ").append(this.toIndentedString(this.audienceOverride)).append("\n");
        sb.append("    defaultRelayState: ").append(this.toIndentedString(this.defaultRelayState)).append("\n");
        sb.append("    destinationOverride: ").append(this.toIndentedString(this.destinationOverride)).append("\n");
        sb.append("    recipientOverride: ").append(this.toIndentedString(this.recipientOverride)).append("\n");
        sb.append("    samlAssertionLifetimeSeconds: ").append(this.toIndentedString(this.samlAssertionLifetimeSeconds)).append("\n");
        sb.append("    ssoAcsUrlOverride: ").append(this.toIndentedString(this.ssoAcsUrlOverride)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

