/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"e", "kid", "kty", "n", "status", "use"})
public class OAuth2ResourceServerJsonWebKeyRequestBody
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_E = "e";
    private String e;
    public static final String JSON_PROPERTY_KID = "kid";
    private JsonNullable<String> kid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_KTY = "kty";
    private String kty;
    public static final String JSON_PROPERTY_N = "n";
    private String n;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_USE = "use";
    private String use;

    public OAuth2ResourceServerJsonWebKeyRequestBody e(String e) {
        this.e = e;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AQAB", value="RSA key value (exponent) for key binding")
    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getE() {
        return this.e;
    }

    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setE(String e) {
        this.e = e;
    }

    public OAuth2ResourceServerJsonWebKeyRequestBody kid(String kid) {
        this.kid = JsonNullable.of((Object)kid);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SIMcCQNY3uwXoW3y0vf6VxiBb5n9pf8L2fK8d-FIbm4", value="Unique identifier of the JSON web key in the custom authorization server's public JWKS")
    @JsonIgnore
    public String getKid() {
        return (String)this.kid.orElse(null);
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getKid_JsonNullable() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    public void setKid_JsonNullable(JsonNullable<String> kid) {
        this.kid = kid;
    }

    public void setKid(String kid) {
        this.kid = JsonNullable.of((Object)kid);
    }

    public OAuth2ResourceServerJsonWebKeyRequestBody kty(String kty) {
        this.kty = kty;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RSA", value="Cryptographic algorithm family for the certificate's key pair")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKty() {
        return this.kty;
    }

    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKty(String kty) {
        this.kty = kty;
    }

    public OAuth2ResourceServerJsonWebKeyRequestBody n(String n) {
        this.n = n;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="mkC6yAJVvFwUlmM9gKjb2d-YK5qHFt-mXSsbjWKKs4EfNm-BoQeeovBZtSACyaqLc8IYFTPEURFcbDQ9DkAL04uUIRD2gaHYY7uK0jsluEaXGq2RAIsmzAwNTzkiDw4q9pDL_q7n0f_SDt1TsMaMQayB6bU5jWsmqcWJ8MCRJ1aJMjZ16un5UVx51IIeCbe4QRDxEXGAvYNczsBoZxspDt28esSpq5W0dBFxcyGVudyl54Er3FzAguhgfMVjH-bUec9j2Tl40qDTktrYgYfxz9pfjm01Hl4WYP1YQxeETpSL7cQ5Ihz4jGDtHUEOcZ4GfJrPzrGpUrak8Qp5xcwCqQ", value="RSA key value (modulus) for key binding")
    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getN() {
        return this.n;
    }

    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    public OAuth2ResourceServerJsonWebKeyRequestBody status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="Status of the JSON Web Key")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OAuth2ResourceServerJsonWebKeyRequestBody use(String use) {
        this.use = use;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="enc", value="Acceptable use of the JSON Web Key")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUse() {
        return this.use;
    }

    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUse(String use) {
        this.use = use;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ResourceServerJsonWebKeyRequestBody oauth2ResourceServerJsonWebKeyRequestBody = (OAuth2ResourceServerJsonWebKeyRequestBody)o;
        return Objects.equals(this.e, oauth2ResourceServerJsonWebKeyRequestBody.e) && OAuth2ResourceServerJsonWebKeyRequestBody.equalsNullable(this.kid, oauth2ResourceServerJsonWebKeyRequestBody.kid) && Objects.equals(this.kty, oauth2ResourceServerJsonWebKeyRequestBody.kty) && Objects.equals(this.n, oauth2ResourceServerJsonWebKeyRequestBody.n) && Objects.equals((Object)this.status, (Object)oauth2ResourceServerJsonWebKeyRequestBody.status) && Objects.equals(this.use, oauth2ResourceServerJsonWebKeyRequestBody.use);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.e, OAuth2ResourceServerJsonWebKeyRequestBody.hashCodeNullable(this.kid), this.kty, this.n, this.status, this.use});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ResourceServerJsonWebKeyRequestBody {\n");
        sb.append("    e: ").append(this.toIndentedString(this.e)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString(this.kty)).append("\n");
        sb.append("    n: ").append(this.toIndentedString(this.n)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    use: ").append(this.toIndentedString(this.use)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

