/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuthClientSecretLinks;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"client_secret", "created", "id", "lastUpdated", "secret_hash", "status", "_links"})
public class OAuth2ClientSecret
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;
    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;
    public static final String JSON_PROPERTY_SECRET_HASH = "secret_hash";
    private String secretHash;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private OAuthClientSecretLinks links;

    @Nullable
    @ApiModelProperty(example="DRUFXGF9XbLn......a3x3POBiIxDreBCdZuFs5B", value="The OAuth 2.0 client secret string")
    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", value="Timestamp when the OAuth Client 2.0 Secret was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(example="ocs2f4zrZbs8nUa7p0g4", value="The unique ID of the OAuth Client Secret")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", value="Timestamp when the OAuth Client 2.0 Secret was updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    @Nullable
    @ApiModelProperty(example="yk4SVx4sUWVJVbHt6M-UPA", value="OAuth 2.0 client secret string hash")
    @JsonProperty(value="secret_hash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecretHash() {
        return this.secretHash;
    }

    public OAuth2ClientSecret status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="Status of the OAuth 2.0 Client Secret")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OAuth2ClientSecret links(OAuthClientSecretLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuthClientSecretLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OAuthClientSecretLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientSecret oauth2ClientSecret = (OAuth2ClientSecret)o;
        return Objects.equals(this.clientSecret, oauth2ClientSecret.clientSecret) && Objects.equals(this.created, oauth2ClientSecret.created) && Objects.equals(this.id, oauth2ClientSecret.id) && Objects.equals(this.lastUpdated, oauth2ClientSecret.lastUpdated) && Objects.equals(this.secretHash, oauth2ClientSecret.secretHash) && Objects.equals((Object)this.status, (Object)oauth2ClientSecret.status) && Objects.equals(this.links, oauth2ClientSecret.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientSecret, this.created, this.id, this.lastUpdated, this.secretHash, this.status, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientSecret {\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    secretHash: ").append(this.toIndentedString(this.secretHash)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

