/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="An RSA signing key")
@JsonPropertyOrder(value={"e", "kty", "n", "kid", "status", "alg", "use", "discriminator"})
public class OAuth2ClientJsonWebKeyRsaRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_E = "e";
    private String e;
    public static final String JSON_PROPERTY_KTY = "kty";
    private KtyEnum kty;
    public static final String JSON_PROPERTY_N = "n";
    private String n;
    public static final String JSON_PROPERTY_KID = "kid";
    private JsonNullable<String> kid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_ALG = "alg";
    private String alg;
    public static final String JSON_PROPERTY_USE = "use";
    private UseEnum use;
    public static final String JSON_PROPERTY_DISCRIMINATOR = "discriminator";
    private JsonNullable<Object> discriminator = JsonNullable.undefined();

    public OAuth2ClientJsonWebKeyRsaRequest e(String e) {
        this.e = e;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="AQAB", required=true, value="RSA key value (exponent) for key binding")
    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getE() {
        return this.e;
    }

    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setE(String e) {
        this.e = e;
    }

    public OAuth2ClientJsonWebKeyRsaRequest kty(KtyEnum kty) {
        this.kty = kty;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RSA", value="Cryptographic algorithm family for the certificate's key pair")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KtyEnum getKty() {
        return this.kty;
    }

    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKty(KtyEnum kty) {
        this.kty = kty;
    }

    public OAuth2ClientJsonWebKeyRsaRequest n(String n) {
        this.n = n;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="mkC6yAJVvFwUlmM9gKjb2d-YK5qHFt-mXSsbjWKKs4EfNm-BoQeeovBZtSACyaqLc8IYFTPEURFcbDQ9DkAL04uUIRD2gaHYY7uK0jsluEaXGq2RAIsmzAwNTzkiDw4q9pDL_q7n0f_SDt1TsMaMQayB6bU5jWsmqcWJ8MCRJ1aJMjZ16un5UVx51IIeCbe4QRDxEXGAvYNczsBoZxspDt28esSpq5W0dBFxcyGVudyl54Er3FzAguhgfMVjH-bUec9j2Tl40qDTktrYgYfxz9pfjm01Hl4WYP1YQxeETpSL7cQ5Ihz4jGDtHUEOcZ4GfJrPzrGpUrak8Qp5xcwCqQ", required=true, value="RSA key value (modulus) for key binding")
    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getN() {
        return this.n;
    }

    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setN(String n) {
        this.n = n;
    }

    public OAuth2ClientJsonWebKeyRsaRequest kid(String kid) {
        this.kid = JsonNullable.of((Object)kid);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SIMcCQNY3uwXoW3y0vf6VxiBb5n9pf8L2fK8d-FIbm4", value="Unique identifier of the JSON Web Key in the OAuth 2.0 client's JWKS")
    @JsonIgnore
    public String getKid() {
        return (String)this.kid.orElse(null);
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getKid_JsonNullable() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    public void setKid_JsonNullable(JsonNullable<String> kid) {
        this.kid = kid;
    }

    public void setKid(String kid) {
        this.kid = JsonNullable.of((Object)kid);
    }

    public OAuth2ClientJsonWebKeyRsaRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="Status of the OAuth 2.0 client JSON Web Key")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OAuth2ClientJsonWebKeyRsaRequest alg(String alg) {
        this.alg = alg;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RS256", value="Algorithm used in the key")
    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlg(String alg) {
        this.alg = alg;
    }

    public OAuth2ClientJsonWebKeyRsaRequest use(UseEnum use) {
        this.use = use;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="sig", value="Acceptable use of the JSON Web Key")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UseEnum getUse() {
        return this.use;
    }

    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUse(UseEnum use) {
        this.use = use;
    }

    public OAuth2ClientJsonWebKeyRsaRequest discriminator(Object discriminator) {
        this.discriminator = JsonNullable.of((Object)discriminator);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Object getDiscriminator() {
        return this.discriminator.orElse(null);
    }

    @JsonProperty(value="discriminator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getDiscriminator_JsonNullable() {
        return this.discriminator;
    }

    @JsonProperty(value="discriminator")
    public void setDiscriminator_JsonNullable(JsonNullable<Object> discriminator) {
        this.discriminator = discriminator;
    }

    public void setDiscriminator(Object discriminator) {
        this.discriminator = JsonNullable.of((Object)discriminator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientJsonWebKeyRsaRequest oauth2ClientJsonWebKeyRsaRequest = (OAuth2ClientJsonWebKeyRsaRequest)o;
        return Objects.equals(this.e, oauth2ClientJsonWebKeyRsaRequest.e) && Objects.equals((Object)this.kty, (Object)oauth2ClientJsonWebKeyRsaRequest.kty) && Objects.equals(this.n, oauth2ClientJsonWebKeyRsaRequest.n) && OAuth2ClientJsonWebKeyRsaRequest.equalsNullable(this.kid, oauth2ClientJsonWebKeyRsaRequest.kid) && Objects.equals((Object)this.status, (Object)oauth2ClientJsonWebKeyRsaRequest.status) && Objects.equals(this.alg, oauth2ClientJsonWebKeyRsaRequest.alg) && Objects.equals((Object)this.use, (Object)oauth2ClientJsonWebKeyRsaRequest.use) && OAuth2ClientJsonWebKeyRsaRequest.equalsNullable(this.discriminator, oauth2ClientJsonWebKeyRsaRequest.discriminator);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.e, this.kty, this.n, OAuth2ClientJsonWebKeyRsaRequest.hashCodeNullable(this.kid), this.status, this.alg, this.use, OAuth2ClientJsonWebKeyRsaRequest.hashCodeNullable(this.discriminator)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientJsonWebKeyRsaRequest {\n");
        sb.append("    e: ").append(this.toIndentedString(this.e)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString((Object)this.kty)).append("\n");
        sb.append("    n: ").append(this.toIndentedString(this.n)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    use: ").append(this.toIndentedString((Object)this.use)).append("\n");
        sb.append("    discriminator: ").append(this.toIndentedString(this.discriminator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum KtyEnum {
        RSA(String.valueOf("RSA")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private KtyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KtyEnum fromValue(String value) {
            for (KtyEnum b : KtyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum UseEnum {
        SIG(String.valueOf("sig")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private UseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UseEnum fromValue(String value) {
            for (UseEnum b : UseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

