/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuth2ClientJsonWebKeyECResponse;
import com.okta.sdk.resource.model.OAuth2ClientJsonWebKeyRsaResponse;
import com.okta.sdk.resource.model.OAuthClientSecretLinks;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A [JSON Web Key (JWK)](https://tools.ietf.org/html/rfc7517) is a JSON representation of a cryptographic key. Okta uses signing keys to verify the signature of a JWT when provided for the `private_key_jwt` client authentication method or for a signed authorize request object. Okta supports both RSA and Elliptic Curve (EC) keys for signing tokens.")
@JsonPropertyOrder(value={"id", "created", "lastUpdated", "_links", "kid", "status", "kty", "alg", "use"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="kty", visible=true, defaultImpl=OAuth2ClientJsonSigningKeyResponse.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=OAuth2ClientJsonWebKeyECResponse.class, name="EC"), @JsonSubTypes.Type(value=OAuth2ClientJsonWebKeyRsaResponse.class, name="RSA")})
public class OAuth2ClientJsonSigningKeyResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private OAuthClientSecretLinks links;
    public static final String JSON_PROPERTY_KID = "kid";
    private JsonNullable<String> kid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_KTY = "kty";
    protected KtyEnum kty;
    public static final String JSON_PROPERTY_ALG = "alg";
    private String alg;
    public static final String JSON_PROPERTY_USE = "use";
    private UseEnum use;

    @Nonnull
    @ApiModelProperty(example="pks2f4zrZbs8nUa7p0g4", required=true, value="The unique ID of the OAuth Client JSON Web Key")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @Nonnull
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", required=true, value="Timestamp when the OAuth 2.0 client JSON Web Key was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCreated() {
        return this.created;
    }

    @Nonnull
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", required=true, value="Timestamp when the OAuth 2.0 client JSON Web Key was updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public OAuth2ClientJsonSigningKeyResponse links(OAuthClientSecretLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuthClientSecretLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OAuthClientSecretLinks links) {
        this.links = links;
    }

    public OAuth2ClientJsonSigningKeyResponse kid(String kid) {
        this.kid = JsonNullable.of((Object)kid);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SIMcCQNY3uwXoW3y0vf6VxiBb5n9pf8L2fK8d-FIbm4", value="Unique identifier of the JSON Web Key in the OAuth 2.0 client's JWKS")
    @JsonIgnore
    public String getKid() {
        return (String)this.kid.orElse(null);
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getKid_JsonNullable() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    public void setKid_JsonNullable(JsonNullable<String> kid) {
        this.kid = kid;
    }

    public void setKid(String kid) {
        this.kid = JsonNullable.of((Object)kid);
    }

    public OAuth2ClientJsonSigningKeyResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="Status of the OAuth 2.0 client JSON Web Key")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OAuth2ClientJsonSigningKeyResponse kty(KtyEnum kty) {
        this.kty = kty;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="RSA", required=true, value="Cryptographic algorithm family for the certificate's key pair")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public KtyEnum getKty() {
        return this.kty;
    }

    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKty(KtyEnum kty) {
        this.kty = kty;
    }

    public OAuth2ClientJsonSigningKeyResponse alg(String alg) {
        this.alg = alg;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="RS256", required=true, value="Algorithm used in the key")
    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAlg(String alg) {
        this.alg = alg;
    }

    public OAuth2ClientJsonSigningKeyResponse use(UseEnum use) {
        this.use = use;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="sig", required=true, value="Acceptable use of the JSON Web Key")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UseEnum getUse() {
        return this.use;
    }

    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUse(UseEnum use) {
        this.use = use;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientJsonSigningKeyResponse oauth2ClientJsonSigningKeyResponse = (OAuth2ClientJsonSigningKeyResponse)o;
        return Objects.equals(this.id, oauth2ClientJsonSigningKeyResponse.id) && Objects.equals(this.created, oauth2ClientJsonSigningKeyResponse.created) && Objects.equals(this.lastUpdated, oauth2ClientJsonSigningKeyResponse.lastUpdated) && Objects.equals(this.links, oauth2ClientJsonSigningKeyResponse.links) && OAuth2ClientJsonSigningKeyResponse.equalsNullable(this.kid, oauth2ClientJsonSigningKeyResponse.kid) && Objects.equals((Object)this.status, (Object)oauth2ClientJsonSigningKeyResponse.status) && Objects.equals((Object)this.kty, (Object)oauth2ClientJsonSigningKeyResponse.kty) && Objects.equals(this.alg, oauth2ClientJsonSigningKeyResponse.alg) && Objects.equals((Object)this.use, (Object)oauth2ClientJsonSigningKeyResponse.use);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.created, this.lastUpdated, this.links, OAuth2ClientJsonSigningKeyResponse.hashCodeNullable(this.kid), this.status, this.kty, this.alg, this.use});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientJsonSigningKeyResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString((Object)this.kty)).append("\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    use: ").append(this.toIndentedString((Object)this.use)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum KtyEnum {
        RSA(String.valueOf("RSA")),
        EC(String.valueOf("EC")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private KtyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KtyEnum fromValue(String value) {
            for (KtyEnum b : KtyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum UseEnum {
        SIG(String.valueOf("sig")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private UseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UseEnum fromValue(String value) {
            for (UseEnum b : UseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

