/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ManagedConnectionPatchableScopeCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Update an existing managed connection. All fields are optional for partial updates.  **Field Applicability by Connection Type:** - `resourceIndicator`: Valid for IDENTITY_ASSERTION_APP_INSTANCE, IDENTITY_ASSERTION_CUSTOM_AS, STS_SERVICE_ACCOUNT, and STS_VAULT_SECRET. Set to `null` to reset to the default value (the resource's ORN). - `scopeCondition` and `scopes`: Only valid for IDENTITY_ASSERTION_APP_INSTANCE and IDENTITY_ASSERTION_CUSTOM_AS connections. The server returns a validation error if these fields are sent for STS connection types.  **Validation:** - If `scopeCondition` is provided, `scopes` must also be provided, and vice versa. - For STS_VAULT_SECRET and STS_SERVICE_ACCOUNT connection types, only `resourceIndicator` can be updated.")
@JsonPropertyOrder(value={"resourceIndicator", "scopeCondition", "scopes"})
public class ManagedConnectionPatchable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_RESOURCE_INDICATOR = "resourceIndicator";
    private JsonNullable<URI> resourceIndicator = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SCOPE_CONDITION = "scopeCondition";
    private JsonNullable<ManagedConnectionPatchableScopeCondition> scopeCondition = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private JsonNullable<List<String>> scopes = JsonNullable.undefined();

    public ManagedConnectionPatchable resourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = JsonNullable.of((Object)resourceIndicator);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resource indicator used when requesting tokens. Set to `null` to reset to the default value based on the connection type (app instance ORN, authorization server ORN, secret ORN, or service account ORN).")
    @JsonIgnore
    public URI getResourceIndicator() {
        return (URI)this.resourceIndicator.orElse(null);
    }

    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getResourceIndicator_JsonNullable() {
        return this.resourceIndicator;
    }

    @JsonProperty(value="resourceIndicator")
    public void setResourceIndicator_JsonNullable(JsonNullable<URI> resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
    }

    public void setResourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = JsonNullable.of((Object)resourceIndicator);
    }

    public ManagedConnectionPatchable scopeCondition(ManagedConnectionPatchableScopeCondition scopeCondition) {
        this.scopeCondition = JsonNullable.of((Object)((Object)scopeCondition));
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public ManagedConnectionPatchableScopeCondition getScopeCondition() {
        return (ManagedConnectionPatchableScopeCondition)((Object)this.scopeCondition.orElse(null));
    }

    @JsonProperty(value="scopeCondition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<ManagedConnectionPatchableScopeCondition> getScopeCondition_JsonNullable() {
        return this.scopeCondition;
    }

    @JsonProperty(value="scopeCondition")
    public void setScopeCondition_JsonNullable(JsonNullable<ManagedConnectionPatchableScopeCondition> scopeCondition) {
        this.scopeCondition = scopeCondition;
    }

    public void setScopeCondition(ManagedConnectionPatchableScopeCondition scopeCondition) {
        this.scopeCondition = JsonNullable.of((Object)((Object)scopeCondition));
    }

    public ManagedConnectionPatchable scopes(List<String> scopes) {
        this.scopes = JsonNullable.of(scopes);
        return this;
    }

    public ManagedConnectionPatchable addscopesItem(String scopesItem) {
        if (this.scopes == null || !this.scopes.isPresent()) {
            this.scopes = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.scopes.get()).add(scopesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of scopes for the connection. For `ALL_SCOPES`, this array must contain a single value of `*`. For `INCLUDE_ONLY`, only these scopes are allowed. For `EXCLUDE`, all scopes except these are allowed.  **Restrictions:** - Only valid for IDENTITY_ASSERTION_APP_INSTANCE and IDENTITY_ASSERTION_CUSTOM_AS connection types - Must be provided together with `scopeCondition` - Returns a 400 error if sent for STS_VAULT_SECRET or STS_SERVICE_ACCOUNT connection types")
    @JsonIgnore
    public List<String> getScopes() {
        return (List)this.scopes.orElse(null);
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getScopes_JsonNullable() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopes_JsonNullable(JsonNullable<List<String>> scopes) {
        this.scopes = scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = JsonNullable.of(scopes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedConnectionPatchable managedConnectionPatchable = (ManagedConnectionPatchable)o;
        return ManagedConnectionPatchable.equalsNullable(this.resourceIndicator, managedConnectionPatchable.resourceIndicator) && ManagedConnectionPatchable.equalsNullable(this.scopeCondition, managedConnectionPatchable.scopeCondition) && ManagedConnectionPatchable.equalsNullable(this.scopes, managedConnectionPatchable.scopes);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(ManagedConnectionPatchable.hashCodeNullable(this.resourceIndicator), ManagedConnectionPatchable.hashCodeNullable(this.scopeCondition), ManagedConnectionPatchable.hashCodeNullable(this.scopes));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManagedConnectionPatchable {\n");
        sb.append("    resourceIndicator: ").append(this.toIndentedString(this.resourceIndicator)).append("\n");
        sb.append("    scopeCondition: ").append(this.toIndentedString(this.scopeCondition)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

