/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentityAssertionAppInstanceConnectionCreatable;
import com.okta.sdk.resource.model.IdentityAssertionAppInstanceConnectionCreatableApp;
import com.okta.sdk.resource.model.IdentityAssertionCustomASConnectionCreatable;
import com.okta.sdk.resource.model.IdentityAssertionCustomASConnectionCreatableAuthorizationServer;
import com.okta.sdk.resource.model.STSServiceAccountConnectionCreatable;
import com.okta.sdk.resource.model.STSServiceAccountConnectionCreatableServiceAccount;
import com.okta.sdk.resource.model.STSVaultSecretConnectionCreatable;
import com.okta.sdk.resource.model.STSVaultSecretConnectionCreatableSecret;
import com.okta.sdk.resource.model.ScopeCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Create a new connection")
@JsonPropertyOrder(value={"app", "connectionType", "issuerUrl", "protocolType", "resourceIndicator", "scopeCondition", "scopes", "authorizationServer", "secret", "serviceAccount"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="connectionType", visible=true, defaultImpl=ManagedConnectionCreatable.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=IdentityAssertionAppInstanceConnectionCreatable.class, name="IDENTITY_ASSERTION_APP_INSTANCE"), @JsonSubTypes.Type(value=IdentityAssertionCustomASConnectionCreatable.class, name="IDENTITY_ASSERTION_CUSTOM_AS"), @JsonSubTypes.Type(value=STSServiceAccountConnectionCreatable.class, name="STS_SERVICE_ACCOUNT"), @JsonSubTypes.Type(value=STSVaultSecretConnectionCreatable.class, name="STS_VAULT_SECRET")})
public class ManagedConnectionCreatable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP = "app";
    private IdentityAssertionAppInstanceConnectionCreatableApp app;
    public static final String JSON_PROPERTY_CONNECTION_TYPE = "connectionType";
    protected ConnectionTypeEnum connectionType;
    public static final String JSON_PROPERTY_ISSUER_URL = "issuerUrl";
    private String issuerUrl;
    public static final String JSON_PROPERTY_PROTOCOL_TYPE = "protocolType";
    private ProtocolTypeEnum protocolType;
    public static final String JSON_PROPERTY_RESOURCE_INDICATOR = "resourceIndicator";
    private URI resourceIndicator;
    public static final String JSON_PROPERTY_SCOPE_CONDITION = "scopeCondition";
    private ScopeCondition scopeCondition;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = new ArrayList<String>();
    public static final String JSON_PROPERTY_AUTHORIZATION_SERVER = "authorizationServer";
    private IdentityAssertionCustomASConnectionCreatableAuthorizationServer authorizationServer;
    public static final String JSON_PROPERTY_SECRET = "secret";
    private STSVaultSecretConnectionCreatableSecret secret;
    public static final String JSON_PROPERTY_SERVICE_ACCOUNT = "serviceAccount";
    private STSServiceAccountConnectionCreatableServiceAccount serviceAccount;

    public ManagedConnectionCreatable app(IdentityAssertionAppInstanceConnectionCreatableApp app) {
        this.app = app;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="app")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IdentityAssertionAppInstanceConnectionCreatableApp getApp() {
        return this.app;
    }

    @JsonProperty(value="app")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApp(IdentityAssertionAppInstanceConnectionCreatableApp app) {
        this.app = app;
    }

    public ManagedConnectionCreatable connectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Type of connection authentication method")
    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConnectionTypeEnum getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
    }

    public ManagedConnectionCreatable issuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Issuer URL for the app instance's authorization server")
    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
    }

    public ManagedConnectionCreatable protocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authentication protocol type used for the connection")
    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolTypeEnum getProtocolType() {
        return this.protocolType;
    }

    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
    }

    public ManagedConnectionCreatable resourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resource indicator used when requesting tokens. Defaults to the service account's ORN if not specified.")
    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getResourceIndicator() {
        return this.resourceIndicator;
    }

    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
    }

    public ManagedConnectionCreatable scopeCondition(ScopeCondition scopeCondition) {
        this.scopeCondition = scopeCondition;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="scopeCondition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ScopeCondition getScopeCondition() {
        return this.scopeCondition;
    }

    @JsonProperty(value="scopeCondition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScopeCondition(ScopeCondition scopeCondition) {
        this.scopeCondition = scopeCondition;
    }

    public ManagedConnectionCreatable scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public ManagedConnectionCreatable addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Array of scopes. Required for all `scopeCondition` values. For `ALL_SCOPES`, this array is required with a single value of `*`. For `INCLUDE_ONLY`, only these scopes are allowed. For `EXCLUDE`, all scopes except these are allowed.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public ManagedConnectionCreatable authorizationServer(IdentityAssertionCustomASConnectionCreatableAuthorizationServer authorizationServer) {
        this.authorizationServer = authorizationServer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="authorizationServer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IdentityAssertionCustomASConnectionCreatableAuthorizationServer getAuthorizationServer() {
        return this.authorizationServer;
    }

    @JsonProperty(value="authorizationServer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthorizationServer(IdentityAssertionCustomASConnectionCreatableAuthorizationServer authorizationServer) {
        this.authorizationServer = authorizationServer;
    }

    public ManagedConnectionCreatable secret(STSVaultSecretConnectionCreatableSecret secret) {
        this.secret = secret;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public STSVaultSecretConnectionCreatableSecret getSecret() {
        return this.secret;
    }

    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSecret(STSVaultSecretConnectionCreatableSecret secret) {
        this.secret = secret;
    }

    public ManagedConnectionCreatable serviceAccount(STSServiceAccountConnectionCreatableServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="serviceAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public STSServiceAccountConnectionCreatableServiceAccount getServiceAccount() {
        return this.serviceAccount;
    }

    @JsonProperty(value="serviceAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceAccount(STSServiceAccountConnectionCreatableServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedConnectionCreatable managedConnectionCreatable = (ManagedConnectionCreatable)o;
        return Objects.equals(this.app, managedConnectionCreatable.app) && Objects.equals((Object)this.connectionType, (Object)managedConnectionCreatable.connectionType) && Objects.equals(this.issuerUrl, managedConnectionCreatable.issuerUrl) && Objects.equals((Object)this.protocolType, (Object)managedConnectionCreatable.protocolType) && Objects.equals(this.resourceIndicator, managedConnectionCreatable.resourceIndicator) && Objects.equals((Object)this.scopeCondition, (Object)managedConnectionCreatable.scopeCondition) && Objects.equals(this.scopes, managedConnectionCreatable.scopes) && Objects.equals(this.authorizationServer, managedConnectionCreatable.authorizationServer) && Objects.equals(this.secret, managedConnectionCreatable.secret) && Objects.equals(this.serviceAccount, managedConnectionCreatable.serviceAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.app, this.connectionType, this.issuerUrl, this.protocolType, this.resourceIndicator, this.scopeCondition, this.scopes, this.authorizationServer, this.secret, this.serviceAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManagedConnectionCreatable {\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    connectionType: ").append(this.toIndentedString((Object)this.connectionType)).append("\n");
        sb.append("    issuerUrl: ").append(this.toIndentedString(this.issuerUrl)).append("\n");
        sb.append("    protocolType: ").append(this.toIndentedString((Object)this.protocolType)).append("\n");
        sb.append("    resourceIndicator: ").append(this.toIndentedString(this.resourceIndicator)).append("\n");
        sb.append("    scopeCondition: ").append(this.toIndentedString((Object)this.scopeCondition)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    authorizationServer: ").append(this.toIndentedString(this.authorizationServer)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    serviceAccount: ").append(this.toIndentedString(this.serviceAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ConnectionTypeEnum {
        STS_SERVICE_ACCOUNT(String.valueOf("STS_SERVICE_ACCOUNT")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ConnectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionTypeEnum fromValue(String value) {
            for (ConnectionTypeEnum b : ConnectionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ProtocolTypeEnum {
        STS(String.valueOf("STS")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ProtocolTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolTypeEnum fromValue(String value) {
            for (ProtocolTypeEnum b : ProtocolTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

