/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CustomAuthorizationServer;
import com.okta.sdk.resource.model.IdentityAssertionAppInstanceConnection;
import com.okta.sdk.resource.model.IdentityAssertionCustomASConnection;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.ManagedConnectionAppInstance;
import com.okta.sdk.resource.model.ManagedConnectionServiceAccount;
import com.okta.sdk.resource.model.ManagedConnectionStatus;
import com.okta.sdk.resource.model.ManagedConnectionVaultedSecret;
import com.okta.sdk.resource.model.STSServiceAccountConnection;
import com.okta.sdk.resource.model.STSVaultSecretConnection;
import com.okta.sdk.resource.model.ScopeCondition;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"app", "authorizationServer", "connectionType", "id", "orn", "protocolType", "resourceIndicator", "scopeCondition", "scopes", "status", "_links", "secret", "serviceAccount"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="connectionType", visible=true, defaultImpl=ManagedConnection.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=IdentityAssertionAppInstanceConnection.class, name="IDENTITY_ASSERTION_APP_INSTANCE"), @JsonSubTypes.Type(value=IdentityAssertionCustomASConnection.class, name="IDENTITY_ASSERTION_CUSTOM_AS"), @JsonSubTypes.Type(value=STSServiceAccountConnection.class, name="STS_SERVICE_ACCOUNT"), @JsonSubTypes.Type(value=STSVaultSecretConnection.class, name="STS_VAULT_SECRET")})
public class ManagedConnection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP = "app";
    private ManagedConnectionAppInstance app;
    public static final String JSON_PROPERTY_AUTHORIZATION_SERVER = "authorizationServer";
    private CustomAuthorizationServer authorizationServer;
    public static final String JSON_PROPERTY_CONNECTION_TYPE = "connectionType";
    protected ConnectionTypeEnum connectionType;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;
    public static final String JSON_PROPERTY_PROTOCOL_TYPE = "protocolType";
    private ProtocolTypeEnum protocolType;
    public static final String JSON_PROPERTY_RESOURCE_INDICATOR = "resourceIndicator";
    private URI resourceIndicator;
    public static final String JSON_PROPERTY_SCOPE_CONDITION = "scopeCondition";
    private ScopeCondition scopeCondition;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ManagedConnectionStatus status;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;
    public static final String JSON_PROPERTY_SECRET = "secret";
    private ManagedConnectionVaultedSecret secret;
    public static final String JSON_PROPERTY_SERVICE_ACCOUNT = "serviceAccount";
    private ManagedConnectionServiceAccount serviceAccount;

    public ManagedConnection app(ManagedConnectionAppInstance app) {
        this.app = app;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="app")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ManagedConnectionAppInstance getApp() {
        return this.app;
    }

    @JsonProperty(value="app")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApp(ManagedConnectionAppInstance app) {
        this.app = app;
    }

    public ManagedConnection authorizationServer(CustomAuthorizationServer authorizationServer) {
        this.authorizationServer = authorizationServer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="authorizationServer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomAuthorizationServer getAuthorizationServer() {
        return this.authorizationServer;
    }

    @JsonProperty(value="authorizationServer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthorizationServer(CustomAuthorizationServer authorizationServer) {
        this.authorizationServer = authorizationServer;
    }

    public ManagedConnection connectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Type of connection authentication method")
    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConnectionTypeEnum getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
    }

    public ManagedConnection id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the managed connection. Only present for managed connections.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ManagedConnection orn(String orn) {
        this.orn = orn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The [ORN](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#okta-resource-name-orn) of the managed connection")
    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrn() {
        return this.orn;
    }

    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrn(String orn) {
        this.orn = orn;
    }

    public ManagedConnection protocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authentication protocol type used for the connection")
    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolTypeEnum getProtocolType() {
        return this.protocolType;
    }

    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
    }

    public ManagedConnection resourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Resource indicator used when requesting tokens.")
    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getResourceIndicator() {
        return this.resourceIndicator;
    }

    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
    }

    public ManagedConnection scopeCondition(ScopeCondition scopeCondition) {
        this.scopeCondition = scopeCondition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="scopeCondition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScopeCondition getScopeCondition() {
        return this.scopeCondition;
    }

    @JsonProperty(value="scopeCondition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopeCondition(ScopeCondition scopeCondition) {
        this.scopeCondition = scopeCondition;
    }

    public ManagedConnection scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public ManagedConnection addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of scopes. Required for all `scopeCondition` values. For `ALL_SCOPES`, this array is required with a single value of `*`. For `INCLUDE_ONLY`, only these scopes are allowed. For `EXCLUDE`, all scopes except these are allowed.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public ManagedConnection status(ManagedConnectionStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ManagedConnectionStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ManagedConnectionStatus status) {
        this.status = status;
    }

    public ManagedConnection links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public ManagedConnection secret(ManagedConnectionVaultedSecret secret) {
        this.secret = secret;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ManagedConnectionVaultedSecret getSecret() {
        return this.secret;
    }

    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSecret(ManagedConnectionVaultedSecret secret) {
        this.secret = secret;
    }

    public ManagedConnection serviceAccount(ManagedConnectionServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="serviceAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ManagedConnectionServiceAccount getServiceAccount() {
        return this.serviceAccount;
    }

    @JsonProperty(value="serviceAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceAccount(ManagedConnectionServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedConnection managedConnection = (ManagedConnection)o;
        return Objects.equals(this.app, managedConnection.app) && Objects.equals(this.authorizationServer, managedConnection.authorizationServer) && Objects.equals((Object)this.connectionType, (Object)managedConnection.connectionType) && Objects.equals(this.id, managedConnection.id) && Objects.equals(this.orn, managedConnection.orn) && Objects.equals((Object)this.protocolType, (Object)managedConnection.protocolType) && Objects.equals(this.resourceIndicator, managedConnection.resourceIndicator) && Objects.equals((Object)this.scopeCondition, (Object)managedConnection.scopeCondition) && Objects.equals(this.scopes, managedConnection.scopes) && Objects.equals((Object)this.status, (Object)managedConnection.status) && Objects.equals(this.links, managedConnection.links) && Objects.equals(this.secret, managedConnection.secret) && Objects.equals(this.serviceAccount, managedConnection.serviceAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.app, this.authorizationServer, this.connectionType, this.id, this.orn, this.protocolType, this.resourceIndicator, this.scopeCondition, this.scopes, this.status, this.links, this.secret, this.serviceAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManagedConnection {\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    authorizationServer: ").append(this.toIndentedString(this.authorizationServer)).append("\n");
        sb.append("    connectionType: ").append(this.toIndentedString((Object)this.connectionType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    orn: ").append(this.toIndentedString(this.orn)).append("\n");
        sb.append("    protocolType: ").append(this.toIndentedString((Object)this.protocolType)).append("\n");
        sb.append("    resourceIndicator: ").append(this.toIndentedString(this.resourceIndicator)).append("\n");
        sb.append("    scopeCondition: ").append(this.toIndentedString((Object)this.scopeCondition)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    serviceAccount: ").append(this.toIndentedString(this.serviceAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ConnectionTypeEnum {
        STS_SERVICE_ACCOUNT(String.valueOf("STS_SERVICE_ACCOUNT")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ConnectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionTypeEnum fromValue(String value) {
            for (ConnectionTypeEnum b : ConnectionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ProtocolTypeEnum {
        STS(String.valueOf("STS")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ProtocolTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolTypeEnum fromValue(String value) {
            for (ProtocolTypeEnum b : ProtocolTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

