/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The `securityContext` object provides security information that is directly related to the evaluation of the event's IP reputation. IP reputation is a trustworthiness rating that evaluates how likely a sender is to be malicious and is based on the sender's IP address. As the name implies, the `securityContext` object is useful for security applications-flagging and inspecting suspicious events.")
@JsonPropertyOrder(value={"asNumber", "asOrg", "domain", "isp", "isProxy", "userBehaviors"})
public class LogSecurityContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AS_NUMBER = "asNumber";
    private JsonNullable<Integer> asNumber = JsonNullable.undefined();
    public static final String JSON_PROPERTY_AS_ORG = "asOrg";
    private JsonNullable<String> asOrg = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private JsonNullable<String> domain = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ISP = "isp";
    private JsonNullable<String> isp = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IS_PROXY = "isProxy";
    private JsonNullable<Boolean> isProxy = JsonNullable.undefined();
    public static final String JSON_PROPERTY_USER_BEHAVIORS = "userBehaviors";
    private JsonNullable<List<String>> userBehaviors = JsonNullable.undefined();

    @Nullable
    @ApiModelProperty(value="The [Autonomous system](https://docs.telemetry.mozilla.org/datasets/other/asn_aggregates/reference) number that's associated with the autonomous system the event request was sourced to")
    @JsonIgnore
    public Integer getAsNumber() {
        if (this.asNumber == null) {
            this.asNumber = JsonNullable.undefined();
        }
        return (Integer)this.asNumber.orElse(null);
    }

    @JsonProperty(value="asNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getAsNumber_JsonNullable() {
        return this.asNumber;
    }

    @JsonProperty(value="asNumber")
    private void setAsNumber_JsonNullable(JsonNullable<Integer> asNumber) {
        this.asNumber = asNumber;
    }

    @Nullable
    @ApiModelProperty(value="The organization that is associated with the autonomous system that the event request is sourced to")
    @JsonIgnore
    public String getAsOrg() {
        if (this.asOrg == null) {
            this.asOrg = JsonNullable.undefined();
        }
        return (String)this.asOrg.orElse(null);
    }

    @JsonProperty(value="asOrg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAsOrg_JsonNullable() {
        return this.asOrg;
    }

    @JsonProperty(value="asOrg")
    private void setAsOrg_JsonNullable(JsonNullable<String> asOrg) {
        this.asOrg = asOrg;
    }

    @Nullable
    @ApiModelProperty(value="The domain name that's associated with the IP address of the inbound event request")
    @JsonIgnore
    public String getDomain() {
        if (this.domain == null) {
            this.domain = JsonNullable.undefined();
        }
        return (String)this.domain.orElse(null);
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDomain_JsonNullable() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    private void setDomain_JsonNullable(JsonNullable<String> domain) {
        this.domain = domain;
    }

    @Nullable
    @ApiModelProperty(value="The Internet service provider that's used to send the event's request")
    @JsonIgnore
    public String getIsp() {
        if (this.isp == null) {
            this.isp = JsonNullable.undefined();
        }
        return (String)this.isp.orElse(null);
    }

    @JsonProperty(value="isp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getIsp_JsonNullable() {
        return this.isp;
    }

    @JsonProperty(value="isp")
    private void setIsp_JsonNullable(JsonNullable<String> isp) {
        this.isp = isp;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether an event's request is from a known proxy")
    @JsonIgnore
    public Boolean getIsProxy() {
        if (this.isProxy == null) {
            this.isProxy = JsonNullable.undefined();
        }
        return (Boolean)this.isProxy.orElse(null);
    }

    @JsonProperty(value="isProxy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getIsProxy_JsonNullable() {
        return this.isProxy;
    }

    @JsonProperty(value="isProxy")
    private void setIsProxy_JsonNullable(JsonNullable<Boolean> isProxy) {
        this.isProxy = isProxy;
    }

    @Nullable
    @ApiModelProperty(value="The result of the user behavior detection models associated with the event")
    @JsonIgnore
    public List<String> getUserBehaviors() {
        if (this.userBehaviors == null) {
            this.userBehaviors = JsonNullable.undefined();
        }
        return (List)this.userBehaviors.orElse(null);
    }

    @JsonProperty(value="userBehaviors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getUserBehaviors_JsonNullable() {
        return this.userBehaviors;
    }

    @JsonProperty(value="userBehaviors")
    private void setUserBehaviors_JsonNullable(JsonNullable<List<String>> userBehaviors) {
        this.userBehaviors = userBehaviors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogSecurityContext logSecurityContext = (LogSecurityContext)o;
        return LogSecurityContext.equalsNullable(this.asNumber, logSecurityContext.asNumber) && LogSecurityContext.equalsNullable(this.asOrg, logSecurityContext.asOrg) && LogSecurityContext.equalsNullable(this.domain, logSecurityContext.domain) && LogSecurityContext.equalsNullable(this.isp, logSecurityContext.isp) && LogSecurityContext.equalsNullable(this.isProxy, logSecurityContext.isProxy) && LogSecurityContext.equalsNullable(this.userBehaviors, logSecurityContext.userBehaviors);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(LogSecurityContext.hashCodeNullable(this.asNumber), LogSecurityContext.hashCodeNullable(this.asOrg), LogSecurityContext.hashCodeNullable(this.domain), LogSecurityContext.hashCodeNullable(this.isp), LogSecurityContext.hashCodeNullable(this.isProxy), LogSecurityContext.hashCodeNullable(this.userBehaviors));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogSecurityContext {\n");
        sb.append("    asNumber: ").append(this.toIndentedString(this.asNumber)).append("\n");
        sb.append("    asOrg: ").append(this.toIndentedString(this.asOrg)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    isp: ").append(this.toIndentedString(this.isp)).append("\n");
        sb.append("    isProxy: ").append(this.toIndentedString(this.isProxy)).append("\n");
        sb.append("    userBehaviors: ").append(this.toIndentedString(this.userBehaviors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

